package com.agilex.healthcare.mobilehealthplatform.datalayer.healthadvocaterequest;

import java.util.*;

import javax.annotation.Resource;

import org.junit.*;

import com.agilex.healthcare.mobilehealthplatform.datalayer.SpringBasedIntegrationRepo;
import com.agilex.healthcare.mobilehealthplatform.domain.HealthAdvocateStatusCode;

public class HealthAdvocateRequestDaoTest extends SpringBasedIntegrationRepo {

	@Resource
	HealthAdvocateRequestDao dao;
	
	HealthAdvocateRequestPo request;
	
	@Before
	public void setup() {
		HealthAdvocateRequestPo basic = createBasicRequest();
		request = dao.createOrUpdateNewHealthAdvocateRequest(basic);
	}
	
	@Test
	public void assertSaved() {
		Assert.assertNotNull(request);
		Assert.assertNotNull(request.getId());
	}
	
	@Test
	public void validateSaveMultiple() {
		HealthAdvocateRequestFormPo formPo = new HealthAdvocateRequestFormPo();
		byte[] form1 = new byte[] {1,2,3,4,5};
		formPo.setRequest(request);
		formPo.setFormPDF(form1);
		formPo.setPatientId(UUID.randomUUID().toString());
		formPo.setStatus(HealthAdvocateStatusCode.SUBMITTED);
		formPo.setRequestDate(new Date());
		
		HealthAdvocateRequestFormPo savedForm1 = dao.saveHealthAdvocateRequestForm(formPo);
		Assert.assertNotNull(savedForm1);
		
		//Assert.assertEquals(form1, savedForm1.getFormPDF());
		
		byte[] form2 = new byte[] {3,4,5,6,7};
		formPo = new HealthAdvocateRequestFormPo();
		formPo.setRequest(request);
		formPo.setFormPDF(form2);
		formPo.setStatus(HealthAdvocateStatusCode.SUBMITTED);
		formPo.setPatientId(UUID.randomUUID().toString());
		formPo.setRequestDate(new Date());
		
		HealthAdvocateRequestFormPo savedForm2 = dao.saveHealthAdvocateRequestForm(formPo);
		Assert.assertNotNull(savedForm2);
		//Assert.assertEquals(form2, savedForm2.getFormPDF());
		
		Assert.assertNotNull(dao.getHealthAdvocateRequestFormPo(request));
	}
	
	HealthAdvocateRequestPo createBasicRequest() {
		HealthAdvocateRequestPo po = new HealthAdvocateRequestPo();
		po.setAddressFirstLine("first line");
		po.setAddressSecondLine("second line");
		
		return po;
	}
	
}
