package com.agilex.healthcare.mobilehealthplatform.datalayer.feedback;

import java.util.Date;

import javax.annotation.Resource;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.SpringBasedIntegrationRepo;
import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentProcessedAsPerUserNeed;
import com.agilex.healthcare.mobilehealthplatform.domain.UserFeedback;

public class UserFeedbackDataLayerRepoTest extends SpringBasedIntegrationRepo {
	@Resource
	UserFeedbackDataLayerRepo dataLayer;
	
	@Test
	public void testSaveFeedback() {
		UserFeedback feedback = new UserFeedback();
		feedback.setAppointmentProcessedAsPerUserNeed(AppointmentProcessedAsPerUserNeed.Always);
		feedback.setRecommendationRating(5);
		feedback.setComments("Appointments app works great");
		feedback.setDateCreated(new Date());
		feedback = dataLayer.saveUserFeedback(feedback);
		assertNotNull(feedback.getUniqueId());
	}

	@Test
	public void testSaveFeedbackWithoutComments() {
		UserFeedback feedback = new UserFeedback();
		feedback.setAppointmentProcessedAsPerUserNeed(AppointmentProcessedAsPerUserNeed.Always);
		feedback.setRecommendationRating(5);
		feedback.setDateCreated(new Date());
		feedback = dataLayer.saveUserFeedback(feedback);
		assertNotNull(feedback.getUniqueId());
	}

}
