package com.agilex.healthcare.mobilehealthplatform.datalayer.facility;

import javax.annotation.Resource;
import javax.ws.rs.WebApplicationException;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.SpringBasedIntegrationRepo;
import com.agilex.healthcare.mobilehealthplatform.domain.Facilities;
import com.agilex.healthcare.mobilehealthplatform.domain.Facility;

public class FacilityInternalDataLayerRepoTest extends SpringBasedIntegrationRepo {
	@Resource
	private FacilityInternalDataLayer dao;
	private static Facility testFacility;
	
	String patientId = "D123401";
	
	static {
		testFacility = new Facility();
		testFacility.setAddress("test address");
		testFacility.setCity("test city");
		testFacility.setFacilityCode("test facility code");
		testFacility.setName("test name");
		testFacility.setParentSiteCode("test parent site code");
		testFacility.setState("test state");
		testFacility.setType("test type");
	}
	
	public FacilityInternalDataLayerRepoTest() {
	}
	
	@Before
	public void setup() {
		dao.saveFacility(testFacility);
	}
	
	@After
	public void tearDown() {
		dao.removeFacility(testFacility.getFacilityCode());
	}
	
	@Test
	public void fetchFacilities() {
		Facilities facilities = dao.fetchFacilities();
		assertTrue(facilities.size() > 0);
	}
	
	@Test
	public void findByInvalidCode() {
		String invalidCode = "invalidCode";
		
		boolean hasWebApplicationException = false;
		try {
			 dao.fetchFacilityByCode(invalidCode);
		} catch (WebApplicationException e) {
			hasWebApplicationException = true;
		}
		
		assertTrue(hasWebApplicationException);
	}
	

	@Test
	public void findByValidCode() {
		String validCode = "test facility code";
		
		Facility facility = dao.fetchFacilityByCode(validCode);
		assertNotNull(facility);
		
		testFacility.setAddress("test address");
		testFacility.setCity("test city");
		testFacility.setFacilityCode("test facility code");
		testFacility.setName("test name");
		testFacility.setParentSiteCode("test parent site code");
		testFacility.setState("test state");
		testFacility.setType("test type");
		
		assertEquals("test name", facility.getName());
		assertEquals("test type", facility.getType());
		assertEquals("test facility code", facility.getFacilityCode());
		assertEquals("test city", facility.getCity());
		assertEquals("test state", facility.getState());
		assertEquals("test address", facility.getAddress());
		assertEquals("test parent site code", facility.getParentSiteCode());
	}
}
