package com.agilex.healthcare.mobilehealthplatform.datalayer.exercise;

import java.util.UUID;

import javax.annotation.Resource;

import org.junit.*;

import com.agilex.healthcare.mobilehealthplatform.datalayer.UserHistoryIntegrationRepo;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.code.ExerciseCode;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;
import com.agilex.healthcare.utility.DateHelper;

public class ExerciseDataLayerRepoTest extends UserHistoryIntegrationRepo {

	@Resource
    ExerciseDataLayerRepo dataLayer;
	
	Exercise exercise;
	String userId;

	@Before
	public void before() {
		userId = UUID.randomUUID().toString();
        exercise = createAndSaveExercise("1/1/2012");
	}

	@After
	public void after() {
		dataLayer.deleteExercise(exercise);
	}
	
	@Test
	public void verifySave() {
		assertNotNull(exercise);
	}

	@Test
	public void verifyUpdate() {
		assertEquals(ExerciseCode.ACTIVITY_TYPE_BICYCLING, exercise.getActivity());

		exercise.setActivity(ExerciseCode.ACTIVITY_TYPE_RUNNING);
		Exercise savedExercise = dataLayer.saveExercise(exercise);

		assertEquals(ExerciseCode.ACTIVITY_TYPE_RUNNING, savedExercise.getActivity());
	}

	@Test
	public void verifyGetSingle() {
		Exercise fetchedExercise = dataLayer.getExercise(userId, exercise.getUniqueId());

		assertEquals(exercise.getActivity(), fetchedExercise.getActivity());
		assertEquals(exercise.getDate(), fetchedExercise.getDate());
		assertTrue(exercise.getDistance() == fetchedExercise.getDistance());
		assertEquals(exercise.getDuration(), fetchedExercise.getDuration());
		assertEquals(exercise.getNotes(), fetchedExercise.getNotes());
		assertEquals(exercise.getIntensity(), fetchedExercise.getIntensity());
		assertEquals(exercise.getPatientId(), fetchedExercise.getPatientId());
	}

	@Test
	public void verifyFetchMultiple() {
		Exercises fetchedExercises = dataLayer.getExercises(userId);
		assertNotNull(fetchedExercises);
		assertEquals(1, fetchedExercises.size());
	}
	
	@Test
	public void verifyFetchMultipleWithFilter() {
		createAndSaveExercise("1/1/2012");

		createAndSaveExercise("1/2/2012");
		createAndSaveExercise("1/3/2012");
		createAndSaveExercise("1/4/2012");

		DateFilter filter = DateFilterFactory.createFilterFromDate(DateHelper.parseDate("1/1/2012"), DateHelper.parseDate("1/3/2012"));
		Exercises fetchedExercises = dataLayer.getExercises(userId, filter);
		assertEquals(4, fetchedExercises.size());
	}
	
	private Exercise createAndSaveExercise(String date) {
        Exercise exercise = new Exercise();
		exercise.setActivity(ExerciseCode.ACTIVITY_TYPE_BICYCLING);
		exercise.setDate(DateHelper.parseDate(date));
		exercise.setDistance(5.0);
		exercise.setDuration(30);
		exercise.setIntensity(ExerciseCode.INTENSITY_MODERATE);
		exercise.setNotes("Exercise Notes");
		exercise.setPatientId(userId);
		exercise.setSourceSystem("Exercise Source System");

		return dataLayer.saveExercise(exercise);		
	}
	
}
