package com.agilex.healthcare.mobilehealthplatform.datalayer.calendar;

import java.util.UUID;
import javax.annotation.Resource;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import org.junit.*;

import com.agilex.healthcare.mobilehealthplatform.datalayer.SpringBasedIntegrationRepo;

public class PatientPublicKeyDataLayerRepoTest extends SpringBasedIntegrationRepo {

	@Resource
	private CalendarKeyDataLayerRepo dataLayer;

    private PatientIdentifier patient;
    private String savedKey;

    @Before
    public void setup() {
        patient = new PatientIdentifier();
        patient.setUniqueId(UUID.randomUUID().toString());
    }

	@Test
	public void testSaveAndRetrieve() {
		savedKey = dataLayer.createKeyForPatient(patient);
		assertNotNull(savedKey);
		
		String key = dataLayer.fetchKeyByPatient(patient);
		assertEquals(savedKey, key);
		
		String patientId = dataLayer.fetchPatientByKey(savedKey);
		assertEquals(patient.getUniqueId(), patientId);
	}
	
	@After
	public void delete() {
		dataLayer.deleteKeyForPatient(patient);
		
		String key = dataLayer.fetchPatientByKey(savedKey);
		assertNull(key);
	}

}
