package com.agilex.healthcare.mobilehealthplatform.datalayer.calendar;

import java.util.UUID;

import javax.annotation.Resource;

import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.SpringBasedIntegrationRepo;
import com.agilex.healthcare.mobilehealthplatform.domain.CalendarEvent;
import com.agilex.healthcare.mobilehealthplatform.domain.CalendarEvents;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.ModeHelper;

public class CalendarEventDataLayerRepoTest extends SpringBasedIntegrationRepo {

	@Resource
	CalendarEventDataLayerRepo dataLayer;
	
	CalendarEvent calendarEvent;
	String userId;

    @BeforeClass
    public static void checkWhetherTestsAreRunningInVeteranDevMode() {
        Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev"));
    }

	@Before
	public void before() {
		userId = UUID.randomUUID().toString();
		calendarEvent = createAndSaveBasicCalendarEvent();
	}
	
	@After
	public void after() {
		dataLayer.deleteCalendarEvent(calendarEvent);
	}

	@Test
	public void verifySave() {
		assertNotNull(calendarEvent);
	}
	
	@Test
	public void verifyFetchSingle() {
		CalendarEvents calendarEvents = dataLayer.fetchCalendarEvents(userId);
		assertNotNull(calendarEvents);
		assertEquals(1, calendarEvents.size());
	}

	public CalendarEvent createAndSaveBasicCalendarEvent() {
		CalendarEvent calendarEvent = new CalendarEvent();
		calendarEvent.setAlertDuration(15);
		calendarEvent.setDuration(0);
		calendarEvent.setPatientId(userId);
		calendarEvent.setSourceSystem("cal event source system");
		calendarEvent.setStartDate(DateHelper.parseDate("01/01/2012"));
		calendarEvent.setTitle("cal event title");
		
		CalendarEvent savedCalendarEvent = dataLayer.saveCalendarEvent(calendarEvent);

		return savedCalendarEvent;
	}

}
