package com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresult;

import static org.junit.Assert.assertTrue;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresult.PCLAssessmentResultDataLayerMock;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResults;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;

public class PCLAssessmentResultDataLayerMockTest {
	PCLAssessmentResultDataLayerMock datalayer = new PCLAssessmentResultDataLayerMock();

	@Test
	public void verifyResultsExistForGallow() {
		PatientIdentifier gallowPatientIdentifier = new PatientIdentifier("default", "D123401");
		AssessmentResults assessmentResults = datalayer.fetchResultsByAssessment(gallowPatientIdentifier, "ptsd", null);
		assertTrue(assessmentResults.size() > 0);
	}

	@Test
	public void verifyResultsExistForAldie() {
		PatientIdentifier gallowPatientIdentifier = new PatientIdentifier("default", "PATID26");
		AssessmentResults assessmentResults = datalayer.fetchResultsByAssessment(gallowPatientIdentifier, "ptsd", null);
		assertTrue(assessmentResults.size() > 0);
	}

	@Test
	public void verifyResultsCanByFilteredForGallow() {
		PatientIdentifier gallowPatientIdentifier = new PatientIdentifier("default", "PATID26");
		AssessmentResults assessmentResults = datalayer.fetchResultsByAssessment(gallowPatientIdentifier, "ptsd", DateFilterFactory.createFilterFromToday());
		assertTrue(assessmentResults.size() == 0);
	}
}