package com.agilex.healthcare.mobilehealthplatform.datalayer.assessment;

import com.agilex.healthcare.mobilehealthplatform.datalayer.SpringBasedIntegrationRepo;
import com.agilex.healthcare.mobilehealthplatform.domain.Assessment;
import com.agilex.healthcare.utility.ModeHelper;
import org.junit.*;
import org.springframework.dao.DataIntegrityViolationException;

import javax.annotation.Resource;

public class AssessmentDataLayerRepoExceptionTest extends SpringBasedIntegrationRepo {
    @Resource
    AssessmentDataLayerRepo dataLayer;

    private Assessment assessment;

    @BeforeClass
    public static void checkWhetherTestsAreRunningInVeteranDevMode() {
        Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev"));
    }

    @Before
    public void setup() {
        assessment = new Assessment();

        assessment.setUniqueTitle("title");
        assessment.setAuthenticationStrategy("authString");
        assessment.setVersion("1.2");
    }

    @Test(expected = DataIntegrityViolationException.class)
    public void saveAssessmentWithoutTile() {

        assessment.setUniqueTitle(null);
        dataLayer.saveAssessment(assessment);

    }

    @Test(expected = DataIntegrityViolationException.class)
    public void saveAssessmentWithoutAuthStrategy() {

        assessment.setAuthenticationStrategy(null);
        dataLayer.saveAssessment(assessment);

    }

    @Test(expected = DataIntegrityViolationException.class)
    public void saveAssessmentWithoutVersion() {

        assessment.setVersion(null);
        dataLayer.saveAssessment(assessment);

    }
}
