package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import javax.annotation.Resource;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.SpringBasedIntegrationRepo;
import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentRequestInProcess;

public class AppointmentRequestInProcessDataLayerRepoTest extends SpringBasedIntegrationRepo {
	
	@Resource
	AppointmentRequestInProcessDataLayerRepo dataLayer;
	
	@Test
 	public void testSaveAppointmentRequestInProcess() {
		AppointmentRequestInProcess arInProcess = createSampleAppointmentRequestInProcess("arInProcess1");
		
		AppointmentRequestInProcess savedRequest = dataLayer.saveAppointmentRequestInProcess(arInProcess);
		
		assertAppointmentRequestInProcess(arInProcess, savedRequest);
	}

	private void assertAppointmentRequestInProcess(AppointmentRequestInProcess arInProcess,
			AppointmentRequestInProcess savedRequest) {
		assertEquals(arInProcess.getAppointmentRequestId(), savedRequest.getAppointmentRequestId());
		assertEquals(arInProcess.getUserId(), savedRequest.getUserId());
		assertEquals(arInProcess.getFirstName(), savedRequest.getFirstName());
		assertEquals(arInProcess.getLastName(), savedRequest.getLastName());
	}
	
	@Test
	public void validateRetrievalOfAppointmentRequestInProcessById(){
		AppointmentRequestInProcess arInProcess = createSampleAppointmentRequestInProcess("arInProcess1");
		dataLayer.saveAppointmentRequestInProcess(arInProcess);
		
		AppointmentRequestInProcess retrievedARInProcess = dataLayer.fetchAppointmentRequestInProcessByAppointmentRequestId(arInProcess.getAppointmentRequestId());

		assertAppointmentRequestInProcess(arInProcess, retrievedARInProcess);
	}

	@Test
	public void validateDeletionOfAppointmentRequestInProcessById(){
		AppointmentRequestInProcess arInProcess = createSampleAppointmentRequestInProcess("arInProcess1");
		dataLayer.saveAppointmentRequestInProcess(arInProcess);

		dataLayer.deleteAppointmentRequestInProcessById(arInProcess.getAppointmentRequestId());
		AppointmentRequestInProcess retrievedARInProcess = dataLayer.fetchAppointmentRequestInProcessByAppointmentRequestId(arInProcess.getAppointmentRequestId());
		
		assertNull(retrievedARInProcess);
	}
	

	@Test
	public void validateDeletionOfAppointmentRequestsInProcessByUserId(){
		AppointmentRequestInProcess arInProcess1 = createSampleAppointmentRequestInProcess("arInProcess1");
		AppointmentRequestInProcess arInProcess2 = createSampleAppointmentRequestInProcess("arInProcess2");
		
		dataLayer.saveAppointmentRequestInProcess(arInProcess1);
		dataLayer.saveAppointmentRequestInProcess(arInProcess2);

		dataLayer.deleteAppointmentRequestInProcessByUserId(arInProcess1.getUserId());
		AppointmentRequestInProcess retrievedARInProcess1 = dataLayer.fetchAppointmentRequestInProcessByAppointmentRequestId(arInProcess1.getAppointmentRequestId());
		AppointmentRequestInProcess retrievedARInProcess2 = dataLayer.fetchAppointmentRequestInProcessByAppointmentRequestId(arInProcess2.getAppointmentRequestId());
		
		assertNull(retrievedARInProcess1);
		assertNull(retrievedARInProcess2);

	}
	

	private AppointmentRequestInProcess createSampleAppointmentRequestInProcess(String id) {
		AppointmentRequestInProcess arInProcess = new AppointmentRequestInProcess();
		arInProcess.setAppointmentRequestId(id);
		arInProcess.setUserId("john.smith");
		arInProcess.setFirstName("John");
		arInProcess.setLastName("     ");
		return arInProcess;
	}
	

}
