package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import javax.annotation.Resource;

import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.SpringBasedIntegrationRepo;
import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentMetric;
import com.agilex.healthcare.utility.ModeHelper;

public class AppointmentMetricsDataLayerRepoTest extends SpringBasedIntegrationRepo {
	@Resource
	private AppointmentMetricsDataLayer dao;
	private static AppointmentMetric testMetric;
	private static final String TEST_METRIC_NAME = "test name";
	
	static {
		testMetric = new AppointmentMetric();
		testMetric.setName(TEST_METRIC_NAME);
		testMetric.setValue(1);
	}
	
	public AppointmentMetricsDataLayerRepoTest() {
	}
	
	@BeforeClass
	public static void checkWhetherTestsAreRunningInVeteranDevMode() {
		Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev", "dev"));
	}
	
	@Before
	public void setup() {
		dao.saveMetric(testMetric);
	}
	
	@After
	public void tearDown() {
		dao.removeMetric(testMetric.getName());
	}
	
	@Test
	public void getMetric() {
		AppointmentMetric metric = dao.getMetric("test name");
		assertNotNull(metric);
		assertEquals(testMetric.getValue(), metric.getValue());
	}
	
	@Test
	public void updateMetric() {
		AppointmentMetric metric = dao.getMetric("test name");
		metric.setValue(3);
		AppointmentMetric savedMetric = dao.saveMetric(metric);
		
		assertEquals(3, savedMetric.getValue());
	}
}
