package com.agilex.healthcare.mobilehealthplatform.datalayer;

import java.util.Date;

import javax.annotation.Resource;

import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.UserLastAccessedTime;

public class UserLastAccessedTimeDataLayerRepoTest extends SpringBasedIntegrationRepo{

	private static final String USER_ID = "1234567";
	
	@Resource
	UserLastAccessedTimeDataLayer dataLayer; 
	
	@Before
	public void setUp() {
		UserLastAccessedTime userLastAccessedTime = new UserLastAccessedTime();
		userLastAccessedTime.setLastAccessedTime(new Date());
		userLastAccessedTime.setUserId(USER_ID);
		dataLayer.saveUserLastAccessedTime(userLastAccessedTime);
	}
	
	@Test
	public void testFetchingOfLastAccessedDate() {
		UserLastAccessedTime userLastAccessedTime = dataLayer.fetchUserLastAccessedTime(USER_ID);
		assertEquals(USER_ID, userLastAccessedTime.getUserId());
		assertNotNull(userLastAccessedTime.getLastAccessedTime());
	}

	@Test
	public void testFetchingOfLastAccessedDateOfUnknownUser() {
		UserLastAccessedTime userLastAccessedTime = dataLayer.fetchUserLastAccessedTime("Unknown");
		assertNull(userLastAccessedTime);
	}

	@Test
	public void testFetchingOfLastAccessedDateOfPreviouslySavedDate() {
		UserLastAccessedTime expectedUserLastAccessedTime = new UserLastAccessedTime();
		expectedUserLastAccessedTime.setLastAccessedTime(new Date());
		expectedUserLastAccessedTime.setUserId(USER_ID);
		dataLayer.saveUserLastAccessedTime(expectedUserLastAccessedTime);

		long currentTime = expectedUserLastAccessedTime.getLastAccessedTime().getTime();
		
		Date earlierTime = new Date(currentTime-1000);
		UserLastAccessedTime earlierUserLastAccessedTime = new UserLastAccessedTime();
		earlierUserLastAccessedTime.setLastAccessedTime(earlierTime);
		earlierUserLastAccessedTime.setUserId(USER_ID);
		dataLayer.saveUserLastAccessedTime(earlierUserLastAccessedTime);
		
		UserLastAccessedTime actualUserLastAccesedTime = dataLayer.fetchUserLastAccessedTime(USER_ID);
		
		assertEquals(expectedUserLastAccessedTime.getLastAccessedTime(), actualUserLastAccesedTime.getLastAccessedTime());
	}
	
	@Test
	public void testFetchingOfLastAccessedDateOfNewlySavedDate() {
		UserLastAccessedTime userLastAccessedTime = new UserLastAccessedTime();
		userLastAccessedTime.setLastAccessedTime(new Date());
		userLastAccessedTime.setUserId(USER_ID);
		dataLayer.saveUserLastAccessedTime(userLastAccessedTime);

		long currentTime = userLastAccessedTime.getLastAccessedTime().getTime();
		
		Date laterTime = new Date(currentTime + 1000);
		UserLastAccessedTime expectedUserLastAccessedTime = new UserLastAccessedTime();
		expectedUserLastAccessedTime.setLastAccessedTime(laterTime);
		expectedUserLastAccessedTime.setUserId(USER_ID);
		dataLayer.saveUserLastAccessedTime(expectedUserLastAccessedTime);
		
		UserLastAccessedTime actualUserLastAccesedTime = dataLayer.fetchUserLastAccessedTime(USER_ID);
		
		assertEquals(expectedUserLastAccessedTime.getLastAccessedTime(), actualUserLastAccesedTime.getLastAccessedTime());
	}
	
}
