package com.agilex.healthcare.utility.xmlhelpertests;

import static org.junit.Assert.assertNotNull;

import java.io.IOException;
import java.io.InputStream;

import org.junit.Test;
import org.w3c.dom.Document;

import com.agilex.healthcare.utility.NullCheckerAssert;
import com.agilex.healthcare.utility.StreamHelper;
import com.agilex.healthcare.utility.XmlHelper;

public class XmlHelperTest {
	private final static String xmlTestDocumentName = "UnitTestSampleXml.xml";

	/*
	 * <?xml version="1.0" encoding="utf-8"?> <patients> <patient>
	 * <dateOfBirth>1972-10-05T00:00:00-04:00</dateOfBirth>
	 * <firstName>Tina</firstName> <gender>F</gender>
	 * <lastName>        </lastName> </patient> </patients>
	 */
	public Document loadSampleAsDocument() {
		return loadSampleAsDocument(xmlTestDocumentName);
	}

	public Document loadSampleAsDocument(String resourceName) {
		String serializedXml = loadSampleAsString(resourceName);
		return XmlHelper.loadXml(serializedXml);
	}

	private String loadSampleAsString(String resourceName) {
		InputStream resourceStream = this.getClass().getResourceAsStream(resourceName);
		if (resourceStream == null) {
			throw new RuntimeException("Unable to load resource (result null).  resource=" + resourceName);
		} else {
			String s = StreamHelper.streamToString(resourceStream, true);
			if (resourceStream != null) {
				try {
					resourceStream.close();
				} catch (IOException e) {
					// error closing stream, but test shouldn't fail
				}
			}
			return s;
		}
	}

	@Test
	public void parseXmlWithoutError() {
		Document doc = loadSampleAsDocument(xmlTestDocumentName);
		assertNotNull(doc);
	}

	@Test
	public void parseXmlAndThenSerialized() {
		String originalXml = loadSampleAsString(xmlTestDocumentName);
		Document doc = XmlHelper.loadXml(originalXml);
		String serializedXml = XmlHelper.xmlToString(doc);
		NullCheckerAssert.assertNotNullish(serializedXml);
	}

	@Test(expected = Exception.class)
	public void parseInvalidXml() {
		XmlHelper.loadXml("xxx");
	}

}
