package com.agilex.healthcare.utility.xmlhelpertests;

import static org.junit.Assert.assertEquals;

import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

import com.agilex.healthcare.utility.XmlHelper;
import com.agilex.healthcare.utility.XpathHelper;

public class XmlHelperGetNodeValueTest {
	private Document doc;

	@Before
	public void setup() {
		XmlHelperTest loader = new XmlHelperTest();
		doc = loader.loadSampleAsDocument();
	}

	@Test
	public void getNodeValueFromElement() {
		Node firstnameNode = XpathHelper.getNode(doc, "//firstName");
		String nodeValue = XmlHelper.getNodeValue(firstnameNode);
		assertEquals("Tina", nodeValue);
	}

	@Test
	public void getNodeValueFromEmptyElement() {
		Node middleNameNode = XpathHelper.getNode(doc, "//middleName");
		String nodeValue = XmlHelper.getNodeValue(middleNameNode);
		assertEquals("", nodeValue);
	}

	@Test
	public void getNodeValueFromNullElement() {
		Node nullNode = XpathHelper.getNode(doc, "//nonexistantnode");
		String nodeValue = XmlHelper.getNodeValue(nullNode);
		assertEquals(null, nodeValue);
	}

	@Test
	public void getNodeValueFromNullElement2() {
		Node nullNode = null;
		String nodeValue = XmlHelper.getNodeValue(nullNode);
		assertEquals(null, nodeValue);
	}

}
