package com.agilex.healthcare.utility.date.datemarshallers;

import static org.junit.Assert.assertEquals;

import org.joda.time.DateTime;
import org.junit.Test;

import com.agilex.healthcare.utility.datemarshallers.AbstractDateMarshaller;
import com.agilex.healthcare.utility.datemarshallers.SimpleDateMarshaller;

public class SimpleDateMarshallerUnmarshallTest {
	private AbstractDateMarshaller marshaller = new SimpleDateMarshaller();

	@Test
	public void dateToString() throws Exception {
		String s = marshaller.marshal(new DateTime(2003, 1, 2, 0, 0, 0, 0).toDate());
		assertEquals("Jan 02, 2003", s);
	}

	@Test
	public void nullToString() throws Exception {
		String s = marshaller.marshal(null);
		assertEquals(null, s);
	}

	@Test
	public void blankToString() throws Exception {
		String s = marshaller.marshal(null);
		assertEquals(null, s);
	}

}
