package com.agilex.healthcare.utility.date.datemarshallers;

import static org.junit.Assert.assertEquals;

import java.util.Date;

import org.joda.time.DateTime;
import org.junit.Test;

import com.agilex.healthcare.utility.datemarshallers.AbstractDateMarshaller;
import com.agilex.healthcare.utility.datemarshallers.SimpleDateMarshaller;

public class SimpleDateMarshallerMarshallTest {
	private AbstractDateMarshaller marshaller = new SimpleDateMarshaller();

	@Test
	public void stringToDateTwoCharacterDay() throws Exception {
		Date dt = marshaller.unmarshal("JAN 02, 2003");
		Date expectedDate = new DateTime(2003, 1, 2, 0, 0, 0, 0).toDate();
		assertEquals(expectedDate, dt);
	}

	@Test
	public void stringToDateOneCharacterDay() throws Exception {
		Date dt = marshaller.unmarshal("JAN 2, 2003");
		Date expectedDate = new DateTime(2003, 1, 2, 0, 0, 0, 0).toDate();
		assertEquals(expectedDate, dt);
	}

	@Test
	public void nullToDate() throws Exception {
		Date dt = marshaller.unmarshal(null);
		assertEquals(null, dt);
	}

	@Test
	public void blankToDate() throws Exception {
		Date dt = marshaller.unmarshal("");
		assertEquals(null, dt);
	}

	@Test(expected = RuntimeException.class)
	public void invalidFormat() throws Exception {
		Date dt = marshaller.unmarshal("1/2/2003");
		Date expectedDate = new DateTime(2003, 1, 2, 0, 0, 0, 0).toDate();
		assertEquals(expectedDate, dt);
	}
}
