package com.agilex.healthcare.utility.date.datemarshallers;

import java.util.Date;

import org.joda.time.DateTime;
import org.junit.Test;

import com.agilex.healthcare.utility.datemarshallers.AbstractDateMarshaller;
import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshallerNoNulls;

public class DateTimeNoNullMarshallerUnmarshallTest {
	private AbstractDateMarshaller marshaller = new DateTimeMarshallerNoNulls();

	@Test
	public void stringToDate() throws Exception {
		String input = "01/02/2003 13:05:23";
		Date expectedDate = new DateTime(2003, 1, 2, 13, 5, 23, 0).toDate();
		DateMarshallerTestRunner.runUnmarshallTest(marshaller, expectedDate, input);
	}

	@Test
	public void nullToDate() throws Exception {
		String input = null;
		Date expectedDate = null;
		DateMarshallerTestRunner.runUnmarshallTest(marshaller, expectedDate, input);
	}

	@Test
	public void blankToDate() throws Exception {
		String input = "";
		Date expectedDate = null;
		DateMarshallerTestRunner.runUnmarshallTest(marshaller, expectedDate, input);
	}

	@Test(expected = RuntimeException.class)
	public void invalidFormat() throws Exception {
		String input = "1-1-2003";
		Date expectedDate = null;
		DateMarshallerTestRunner.runUnmarshallTest(marshaller, expectedDate, input);
	}

}
