package com.agilex.healthcare.utility.date.datemarshallers;

import java.util.Date;

import org.joda.time.DateTime;
import org.junit.Test;

import com.agilex.healthcare.utility.datemarshallers.AbstractDateMarshaller;
import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;

public class DateTimeMarshallerMarshallTest {
	private AbstractDateMarshaller marshaller = new DateTimeMarshaller();

	@Test
	public void marshall() throws Exception {
		Date input = new DateTime(2003, 1, 2, 4, 5, 23, 0).toDate();
		String expectedDate = "01/02/2003 04:05:23";
		DateMarshallerTestRunner.runMarshallTest(marshaller, expectedDate, input);
	}
	@Test
	public void marshallPm() throws Exception {
		Date input = new DateTime(2003, 1, 2, 13, 5, 23, 0).toDate();
		String expectedDate = "01/02/2003 13:05:23";
		DateMarshallerTestRunner.runMarshallTest(marshaller, expectedDate, input);
	}

	@Test
	public void nullToDate() throws Exception {
		Date input = null;
		String expectedDate = null;
		DateMarshallerTestRunner.runMarshallTest(marshaller, expectedDate, input);
	}

}
