package com.agilex.healthcare.utility.date;

import static org.junit.Assert.assertEquals;

import java.util.Date;

import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.junit.Test;

import com.agilex.healthcare.utility.DateHelper;

public class JodaPeriodTest {
	@Test
	public void calculateYearsBetweenTwoDatesWithExactYearDifference() {
		Date jdkDateA = DateHelper.parseDate("1/1/2001");
		Date jdkDateB = DateHelper.parseDate("1/1/2003");

		DateTime jodaDateA = new DateTime(jdkDateA);
		DateTime jodaDateB = new DateTime(jdkDateB);

		Period p = new Period(jodaDateA, jodaDateB);
		assertEquals(2, p.getYears());
	}

	@Test
	public void calculateYearsBetweenTwoDatesWithInexactYearDifference() {
		Date jdkDateA = DateHelper.parseDate("1/1/2001");
		Date jdkDateB = DateHelper.parseDate("6/1/2003");

		DateTime jodaDateA = new DateTime(jdkDateA);
		DateTime jodaDateB = new DateTime(jdkDateB);

		Period p = new Period(jodaDateA, jodaDateB);
		assertEquals(2, p.getYears());
	}

	@Test
	public void calculateDaysBetweenTwoDates() {
		Date jdkDateA = DateHelper.parseDate("1/1/2001");
		Date jdkDateB = DateHelper.parseDate("1/2/2001");

		DateTime jodaDateA = new DateTime(jdkDateA);
		DateTime jodaDateB = new DateTime(jdkDateB);

		Period p = new Period(jodaDateA, jodaDateB);
		assertEquals(1, p.getDays());
	}

	@Test
	public void calculateSecsBetweenTwoDates() {
		Date jdkDateA = DateHelper.parseDateTime("1/1/2001 12:00:00");
		Date jdkDateB = DateHelper.parseDateTime("1/1/2001 13:01:01");

		DateTime jodaDateA = new DateTime(jdkDateA);
		DateTime jodaDateB = new DateTime(jdkDateB);

		//duration is appropriate for deltas
		Duration delta = new Duration(jodaDateA, jodaDateB);
		assertEquals( (1*60*60+1*60+1)*1000 , delta.getMillis());

		//period is not appropriate for calculating deltas
		Period period = new Period(jodaDateA, jodaDateB);
		assertEquals(1,  period.getSeconds()  );
	}
}
