package com.agilex.healthcare.utility.audit;

import org.junit.Test;

public class ThreadDiscoveryTests {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(ThreadDiscoveryTests.class);

	@Test
	public void currentThreadInfo() {
		Thread t = Thread.currentThread();
		logger.debug(String.format("current thread id:%s;name=%s;thread=%s", t.getId(), t.getName(), t.toString()));
	}

	@Test
	public void sleepThread() throws InterruptedException {
		Thread t = Thread.currentThread();
		logger.debug(String.format("current thread id:%s;name=%s;thread=%s;hash=%s", t.getId(), t.getName(), t.toString(), t.hashCode()));
		logger.debug("sleep for " + 1000);
		Thread.sleep(1000);
		logger.debug("done with sleep for " + 1000);
		logger.debug(String.format("current thread id:%s;name=%s;thread=%s;hash=%s", t.getId(), t.getName(), t.toString(), t.hashCode()));
	}
}
