package com.agilex.healthcare.utility.atom;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import org.junit.Test;
import org.w3c.dom.Document;

import com.agilex.healthcare.mobilehealthplatform.domain.AtomLink;
import com.agilex.healthcare.mobilehealthplatform.domain.AtomLinks;
import com.agilex.healthcare.utility.XpathHelper;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;

public class AtomUtilityTest {
	@Test
	public void createFeedFromNoLinks() {
		AtomLinks links = new AtomLinks();
		URI feedUri = UriBuilder.fromPath("http://server/myfeed").build();
		String feedTitle = "my feed";

		SyndFeed feed = AtomUtility.createAtomFeed(links, feedUri, feedTitle);
		assertNotNull(feed);
	}

	@Test
	public void createFeedFromNullLinks() {
		AtomLinks links = null;
		URI feedUri = UriBuilder.fromPath("http://server/myfeed").build();
		String feedTitle = "my feed";

		SyndFeed feed = AtomUtility.createAtomFeed(links, feedUri, feedTitle);
		assertNotNull(feed);
	}

	@Test
	public void createFeedFromSingleLink() {
		AtomLinks links = new AtomLinks();
		AtomLink link1 = new AtomLink();
		link1.setHref(UriBuilder.fromPath("http://server/link1").build());
		links.add(link1);
		URI feedUri = UriBuilder.fromPath("http://server/myfeed").build();
		String feedTitle = "my feed";

		SyndFeed feed = AtomUtility.createAtomFeed(links, feedUri, feedTitle);
		SyndEntry entry1 = (SyndEntry) feed.getEntries().get(0);
		assertNotNull(entry1);
		assertEquals(link1.getHref().toString(), entry1.getLink().toString());
	}

	@Test
	public void createFeedFromMultipleLinks() {
		AtomLinks links = new AtomLinks();
		AtomLink link1 = new AtomLink();
		link1.setHref(UriBuilder.fromPath("http://server/link1").build());
		links.add(link1);
		AtomLink link2 = new AtomLink();
		link2.setHref(UriBuilder.fromPath("http://server/link2").build());
		links.add(link2);

		URI feedUri = UriBuilder.fromPath("http://server/myfeed").build();
		String feedTitle = "my feed";

		SyndFeed feed = AtomUtility.createAtomFeed(links, feedUri, feedTitle);
		SyndEntry entry1 = (SyndEntry) feed.getEntries().get(0);
		assertEquals(link1.getHref().toString(), entry1.getLink());
		SyndEntry entry2 = (SyndEntry) feed.getEntries().get(1);
		assertEquals(link2.getHref().toString(), entry2.getLink().toString());
	}

	@Test
	public void ensureFeedHasTitle() {
		URI feedUri = UriBuilder.fromPath("http://server/myfeed").build();
		String feedTitle = "my feed";

		SyndFeed feed = AtomUtility.createAtomFeed(new AtomLinks(), feedUri, feedTitle);
		assertEquals(feedTitle, feed.getTitle());
	}

	@Test
	public void ensureFeedHasLink() {
		URI feedUri = UriBuilder.fromPath("http://server/myfeed").build();
		String feedTitle = "my feed";

		SyndFeed feed = AtomUtility.createAtomFeed(new AtomLinks(), feedUri, feedTitle);
		assertEquals(feedUri.toString(), feed.getLink());
	}

	@Test
	public void feedToXml() {
		AtomLinks links = new AtomLinks();
		AtomLink link1 = new AtomLink();
		link1.setHref(UriBuilder.fromPath("http://server/link1").build());
		links.add(link1);
		URI feedUri = UriBuilder.fromPath("http://server/myfeed").build();
		String feedTitle = "my feed";

		SyndFeed feed = AtomUtility.createAtomFeed(links, feedUri, feedTitle);

		Document feedXml = AtomUtility.feedToXml(feed);
		String feedUriFromXml = XpathHelper.getString(feedXml, "//rss/channel/link");
		assertEquals(feedUri.toString(), feedUriFromXml);
		String linkUriFromXml = XpathHelper.getString(feedXml, "//rss/channel/item/link");
		assertEquals(link1.getHref().toString(), linkUriFromXml);
	}
}
