package com.agilex.healthcare.utility.atom;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import javax.ws.rs.core.UriBuilder;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;

public class AtomUtilityCreatePatientFeedTest {
	@Test
	public void createFeedFromNoLinks() {
		String feedTitle = "patient feed";
		Patients patients = new Patients();
		patients.setSelfUri(UriBuilder.fromPath("http://server/patientfeed").build());

		SyndFeed feed = AtomUtility.createAtomFeed(patients, feedTitle);
		assertNotNull(feed);
	}

	@Test
	public void createFeedFromNullLinks() {
		String feedTitle = "patient feed";
		Patients patients = null;

		SyndFeed feed = AtomUtility.createAtomFeed(patients, feedTitle);
		assertNotNull(feed);
	}

	@Test
	public void createFeedFromNullSelfLinks() {
		String feedTitle = "patient feed";
		Patients patients = new Patients();

		SyndFeed feed = AtomUtility.createAtomFeed(patients, feedTitle);
		assertNotNull(feed);
	}

	@Test
	public void createFeed() {
		String feedTitle = "patient feed";
		Patients patients = new Patients();
		patients.setSelfUri(UriBuilder.fromPath("http://server/patientfeed").build());
		Patient patient = new Patient();
		patient.setSelfUri(UriBuilder.fromPath("http://server/patient/A").build());
		patients.add(patient);

		SyndFeed feed = AtomUtility.createAtomFeed(patients, feedTitle);
		SyndEntry entry = (SyndEntry) feed.getEntries().get(0);
		assertEquals ( patient.getSelfUri().toString() , entry.getLink()   ) ;
	}
}
