package com.agilex.healthcare.utility;

import static org.junit.Assert.assertEquals;

import java.util.Collections;

import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntries;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntry;


public class VitalEntryComparatorTest {
	
	private VitalEntry vitalEntry1;
	private VitalEntry vitalEntry2;
	private VitalEntry vitalEntry3;
	private VitalEntry vitalEntry4;
	private VitalEntryTimeComparator comparator;

	@Before
	public void setup(){
		
		
		vitalEntry1 = new VitalEntry();
		vitalEntry1.setEntryDate(DateHelper.parse("10/15/2011 10:00 AM", "MM/dd/yyyy hh:mm a"));
		vitalEntry2 = new VitalEntry();
		vitalEntry2.setEntryDate(DateHelper.parse("10/12/2011 11:00 AM", "MM/dd/yyyy hh:mm a"));
		vitalEntry3 = new VitalEntry();
		vitalEntry3.setEntryDate(DateHelper.parse("10/15/2011 9:00 AM", "MM/dd/yyyy hh:mm a"));
		vitalEntry4 = new VitalEntry();
		vitalEntry4.setEntryDate(DateHelper.parse("10/15/2011 11:59 AM", "MM/dd/yyyy hh:mm a"));
		
		
		comparator = new VitalEntryTimeComparator();
	}

	@Test
	public void validateVitalsAreSortedByTimeInAscendingOrder(){
		
		VitalEntries vitalEntries = new VitalEntries();
		vitalEntries.add(vitalEntry1);
		vitalEntries.add(vitalEntry2);
		vitalEntries.add(vitalEntry3);
		vitalEntries.add(vitalEntry4);

		
		Collections.sort(vitalEntries, comparator);
		
		assertEquals(vitalEntry2.getEntryDate(), vitalEntries.get(0).getEntryDate());
		assertEquals(vitalEntry3.getEntryDate(), vitalEntries.get(1).getEntryDate());
		assertEquals(vitalEntry1.getEntryDate(), vitalEntries.get(2).getEntryDate());
		assertEquals(vitalEntry4.getEntryDate(), vitalEntries.get(3).getEntryDate());
		
	}

	@Test
	public void validateVitalsAreSortedByTimeInDescendingOrder(){
		
		VitalEntries vitalEntries = new VitalEntries();
		
		vitalEntries.add(vitalEntry1);
		vitalEntries.add(vitalEntry2);
		vitalEntries.add(vitalEntry3);
		vitalEntries.add(vitalEntry4);
		
		Collections.sort(vitalEntries, comparator);
		Collections.reverse(vitalEntries);
		
		assertEquals(vitalEntry4.getEntryDate(), vitalEntries.get(0).getEntryDate());
		assertEquals(vitalEntry1.getEntryDate(), vitalEntries.get(1).getEntryDate());
		assertEquals(vitalEntry3.getEntryDate(), vitalEntries.get(2).getEntryDate());
		assertEquals(vitalEntry2.getEntryDate(), vitalEntries.get(3).getEntryDate());
		
	}

}
