package com.agilex.healthcare.utility;

import static org.junit.Assert.assertEquals;

import java.util.Date;

import org.junit.Test;

public class VistaDateParsingTest {
	@Test
	public void parseNull() {
		String input = null;
		Date expected = null;
		assertEquals( expected, DateHelper.parseVistaDate(input)  );
	}
	@Test
	public void parseEmpty() {
		String input = "";
		Date expected = null;
		assertEquals( expected, DateHelper.parseVistaDate(input)  );
	}

	@Test
	public void parseSimpleDate() {
		String input = "3110317";
		Date expected = DateHelper.parseDate("03/17/2011");
		assertEquals( expected, DateHelper.parseVistaDate(input)  );
	}
	@Test
	public void parseSimpleDateIgnoreTime() {
		String input = "3110317.12312";
		Date expected = DateHelper.parseDate("03/17/2011");
		assertEquals( expected, DateHelper.parseVistaDate(input)  );
	}
}
