package com.agilex.healthcare.utility;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.nio.charset.Charset;

import org.junit.Test;

public class StringTruncatorTest {
	private static final int MAX_NOTIFICATION_LENGTH_IN_BYTES = 160;
	
	private void printResult(String original, String result) {
		System.out.println("truncated result: " + result);
		System.out.println("original length: " + original.length());
		System.out.println("original bytes: " + original.getBytes(Charset.forName("UTF-8")).length);
		System.out.println("result bytes:" + result.getBytes(Charset.forName("UTF-8")).length);
	}

	@Test
	public void preserveString() {
		String original = "aaaaaa";
		String result = StringTruncator.truncate(original, MAX_NOTIFICATION_LENGTH_IN_BYTES);
		printResult(original, result);
		assertEquals(original, result);
		assertTrue(result.getBytes(Charset.forName("UTF-8")).length <= MAX_NOTIFICATION_LENGTH_IN_BYTES);
	}
	
	@Test
	public void truncateString() {
		String original = "This is a test sentence.  Here are quotes ''\"\" and symbols !@#$%^&*()[]+=;:/?<>.  Continue sentence for ~` ., Test more.	 ,\n\t\r" +
				"This is a test sentence.  Here are quotes ''\"\" and symbols !@#$%^&*()[]+=;:/?<>.  Continue sentence for ~` ., Test more.";
		String result = StringTruncator.truncate(original, MAX_NOTIFICATION_LENGTH_IN_BYTES);
		printResult(original, result);
		assertTrue(result.getBytes(Charset.forName("UTF-8")).length <= MAX_NOTIFICATION_LENGTH_IN_BYTES);
	}
	
	@Test
	public void truncateString2() {
		StringBuilder sb = new StringBuilder();
		sb.append("0234567890");
		sb.append("1234567890");
		sb.append("2234567890");
		sb.append("3234567890");
		sb.append("4234567890");
		sb.append("5234567890");
		sb.append("6234567890");
		sb.append("7234567890");
		sb.append("8234567890");
		sb.append("9234567890");
		sb.append("0234567890");
		sb.append("1234567890");
		sb.append("2234567890");
		sb.append("3234567890");
		sb.append("4234567890");
		sb.append("5234567890");
		sb.append("6234567890");
		sb.append("7234567890");
		sb.append("8234567890");
		sb.append("9234567890");
		sb.append("0234567890");
		String original = sb.toString();
		String result = StringTruncator.truncate(original, MAX_NOTIFICATION_LENGTH_IN_BYTES);
		printResult(original, result);
		assertTrue(result.getBytes(Charset.forName("UTF-8")).length <= MAX_NOTIFICATION_LENGTH_IN_BYTES);
	}
	
	@Test
	public void truncateInternationalString() {
		StringBuilder sb = new StringBuilder();
		sb.append("ಬಾ ಇಲ್ಲಿ ಸಂಭವಿಸು ಇಂದೆನ್ನ ಹೃದಯದಲಿ ಬಾ ಇಲ್ಲಿ ಸಂಭವಿಸು ಇಂದೆನ್ನ ಹೃದಯದಲಿ ಬಾ ಇಲ್ಲಿ ಸಂಭವಿಸು ಇಂದೆನ್ನ ಹೃದಯದಲಿ");
		String original = sb.toString();
		String result = StringTruncator.truncate(original, MAX_NOTIFICATION_LENGTH_IN_BYTES);
		printResult(original, result);
		assertTrue(result.getBytes(Charset.forName("UTF-8")).length <= MAX_NOTIFICATION_LENGTH_IN_BYTES);
	}
}
