package com.agilex.healthcare.utility;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.utility.datemarshallers.SimpleDateMarshaller;

public class SimpleDateMarshallerTest {

	private SimpleDateFormat df;
	private String dateStr;
	private SimpleDateMarshaller customMarshaller;

	@Before
	public void setup() {
		df = new SimpleDateFormat("MMM dd, yyyy");
		customMarshaller = new SimpleDateMarshaller();
	}

	@Test
	public void serializeSimpleDate() throws Exception {
		dateStr = "Jan 01, 2000";
		Date dt = df.parse(dateStr);
		String s = customMarshaller.marshal(dt);
		assertEquals(dateStr, s);
	}

	@Test
	public void serializeSimpleDateMar102010() throws Exception {
		dateStr = "Mar 10, 2010";
		Date dt = df.parse(dateStr);
		String s = customMarshaller.marshal(dt);
		assertEquals(dateStr, s);
	}

	@Test
	public void deserializeSimpleDateJan022010() throws Exception {
		dateStr = "Jan 01, 2010";
		Date dt = df.parse(dateStr);
		Date unmarshalledDate = customMarshaller.unmarshal(dateStr);
		assertEquals(dt, unmarshalledDate);

	}

	@Test
	public void deserializeSimpleDateMar102010() throws Exception {
		dateStr = "Mar 10, 2010";
		Date dt = df.parse(dateStr);
		Date unmarshalledDate = customMarshaller.unmarshal(dateStr);
		assertEquals(dt, unmarshalledDate);

	}

	@Test
	public void validateSerializeWorksWithNullInput() throws Exception {
		String s = customMarshaller.marshal(null);
		assertNull(s);
	}

	@Test
	public void validateDeSerializeWorksWithNullInput() throws Exception {
		Date s = customMarshaller.unmarshal(null);
		assertNull(s);
	}

	@Test
	public void validateDeSerializeWorksWithEmptyStringInput() throws Exception {
		Date s = customMarshaller.unmarshal("");
		assertNull(s);
	}

	@Test(expected = Exception.class)
	public void validateUnMarshallThrowsExceptionForInvalidInput() throws Exception {
		customMarshaller.unmarshal("398592384");
	}

}
