package com.agilex.healthcare.utility;

import static org.junit.Assert.assertEquals;

import javax.ws.rs.core.UriBuilder;

import org.junit.Test;

public class ResourceUriEncoderTest {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(ResourceUriEncoderTest.class);

	@Test
	public void encodeDecode() {
		String original = UriBuilder.fromPath("http://server/resource").build().toString();
		String encoded = ResourceUriEncoder.encodeUri(original);
		String decoded = ResourceUriEncoder.decodeUri(encoded);
		logger.debug(String.format("[%s]->[%s]->[%s]", original, encoded, decoded));
		assertEquals(original, decoded);
	}

}
