package com.agilex.healthcare.utility;

import junit.framework.Assert;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;

public class PatientIdentitiyHelperTest {

	PatientIdentityHelper helper = new PatientIdentityHelper();
	
	@Test
	public void validatePadding() {
		PatientIdentifier patientIdentifier = new PatientIdentifier("ICN", "1234567890V123456");
		PatientIdentifier alteredIcn = helper.padIcn(patientIdentifier);
		Assert.assertEquals("0000001234567890V123456000000", alteredIcn.getUniqueId());
	}
	
	@Test
	public void validatePaddingIgnoresNonIcn() {
		PatientIdentifier patientIdentifier = new PatientIdentifier("EDIPI", "some-value");
		PatientIdentifier alteredIcn = helper.padIcn(patientIdentifier);
		Assert.assertEquals("some-value", alteredIcn.getUniqueId());
	}
	
	@Test
	public void validateTruncation() {
		PatientIdentifier patientIdentifier = new PatientIdentifier("ICN", "1234567890V123456");
		PatientIdentifier alteredIcn = helper.truncateICN(patientIdentifier);
		Assert.assertEquals("1234567890", alteredIcn.getUniqueId());
	}
	
	@Test
	public void validateTruncationWithMockIcnValue() {
		PatientIdentifier patientIdentifier = new PatientIdentifier("ICN", "PATID40");
		PatientIdentifier alteredIcn = helper.truncateICN(patientIdentifier);
		Assert.assertEquals("PATID40", alteredIcn.getUniqueId());
	}
	
	@Test
	public void validateTruncationIgnoresNonIcn() {
		PatientIdentifier patientIdentifier = new PatientIdentifier("EDIPI", "some-value");
		PatientIdentifier alteredIcn = helper.truncateICN(patientIdentifier);
		Assert.assertEquals("some-value", alteredIcn.getUniqueId());
	}
	
}
