package com.agilex.healthcare.utility;

import org.junit.Test;
import static org.junit.Assert.*;

import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.Medications;

public class PaginatorTest {

	@Test
	public void verifyZeroBasedPagination() {
		Medications page = new Medications();
		Medications medications = initialize(10);
		
		Paginator<Medication, Medications> paginator = new Paginator<Medication, Medications>(0, 5, 0);
		paginator.paginate(medications, page);
		assertEquals(page.size(), 5);
		for(int i = 0; i < 5; i++) {
			assertTrue(page.get(i).getDrugName().equals(Integer.toString(i)));
		}
		
		page.clear();
		paginator.setPageNumber(1);
		paginator.paginate(medications, page);
		assertEquals(page.size(), 5);
		for(int i = 0; i < 5; i++) {
			assertEquals(Integer.toString(i+5), page.get(i).getDrugName());
		}
	}
	
	@Test
	public void verifyOffByOneFixed() {
		Medications page = new Medications();
		Medications medications = initialize(3);
		
		Paginator<Medication, Medications> paginator = new Paginator<Medication, Medications>(1, 2, 1);
		paginator.paginate(medications, page);
		assertEquals(2, page.size());
		for(int i = 0; i < 2; i++) {
			assertEquals(Integer.toString(i), page.get(i).getDrugName());
		}
		
		page.clear();
		paginator.setPageNumber(2);
		paginator.paginate(medications, page);
		assert(page.size() == 1);
		for(int i = 0; i < 1; i++) {
			assertEquals(Integer.toString(i+2), page.get(i).getDrugName());
		}
	}
	
	@Test
	public void verifyOneBasedPagination() {
		Medications page = new Medications();
		Medications medications = initialize(10);
		
		Paginator<Medication, Medications> paginator = new Paginator<Medication, Medications>(1, 5, 1);
		paginator.paginate(medications, page);
		assertEquals(5, page.size());
		for(int i = 0; i < 4; i++) {
			assertEquals(Integer.toString(i), page.get(i).getDrugName());
		}
		
		page.clear();
		paginator.setPageNumber(2);
		paginator.paginate(medications, page);
		assertEquals(5, page.size());
		for(int i = 0; i < 5; i++) {
			assertEquals(Integer.toString(i+5), page.get(i).getDrugName());
		}
	}

	public Medications initialize(int size) {
		Medications medications = new Medications();
		
		for (int i = 0; i < size; i++) {
			Medication medication = new Medication();
			medication.setDrugName(Integer.toString(i));
			medications.add(medication);
		}
		
		return medications;
	}
}
