package com.agilex.healthcare.utility;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

public class NullSafeStringComparerTest {
	@Test
	public void twoEqualString() {
		assertEquals(true, NullSafeStringComparer.areEqual("aaa", "aaa"));
	}

	@Test
	public void twoUnequalString() {
		assertEquals(false, NullSafeStringComparer.areEqual("aaa", "bbb"));
	}

	@Test
	public void firstNullStrings() {
		assertEquals(false, NullSafeStringComparer.areEqual(null, "aaa"));
	}

	@Test
	public void secondNullStrings() {
		assertEquals(false, NullSafeStringComparer.areEqual("aaa", null));
	}

	@Test
	public void twoNullStrings() {
		assertEquals(true, NullSafeStringComparer.areEqual(null, null));
	}

	@Test
	public void firstEmptyStrings() {
		assertEquals(false, NullSafeStringComparer.areEqual("", "aaa"));
	}

	@Test
	public void secondEmptyStrings() {
		assertEquals(false, NullSafeStringComparer.areEqual("aaa", ""));
	}

	@Test
	public void twoEmptyStrings() {
		assertEquals(true, NullSafeStringComparer.areEqual("", ""));
	}

	@Test
	public void emptyAndNull() {
		assertEquals(false, NullSafeStringComparer.areEqual("", null));
	}

	@Test
	public void nullAndEmpty() {
		assertEquals(false, NullSafeStringComparer.areEqual(null, ""));
	}
	
	@Test
	public void verifyCase() {
		assertEquals(true, NullSafeStringComparer.areEqualIgnoreCase("equal", "EQUAL"));
	}
	
	@Test
	public void verifyCaseWithEmpty() {
		assertEquals(false, NullSafeStringComparer.areEqualIgnoreCase(null, "notequal"));
	}
	
	@Test
	public void verifyEmptyWithCase() {
		assertEquals(false, NullSafeStringComparer.areEqualIgnoreCase("notequal", null));
	}
	
	@Test
	public void verifyCaseTwoNulls() {
		assertEquals(true, NullSafeStringComparer.areEqualIgnoreCase(null, null));
	}
}
