package com.agilex.healthcare.utility;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

public class ModeHelperTest {

	@Test
	public void validateIsMode() {
		System.setProperty("org.apache.cocoon.mode", "test");
		assertTrue(ModeHelper.isMode("test"));
	}

	@Test
	public void validateGetCurrentMode() {
		System.setProperty("org.apache.cocoon.mode", "newmode");
		assertEquals("newmode", ModeHelper.getCurrentMode());
	}

	@Test
	public void validateVeteranMode() {
		System.setProperty("org.apache.cocoon.mode", "va-veteran-dev");
		assertTrue(ModeHelper.isVeteranMode());
	}

	@Test
	public void validateVeteranTestMode() {
		System.setProperty("org.apache.cocoon.mode", "va-veteran-test");
		assertTrue(ModeHelper.isVeteranMode());
	}

	@Test
	public void validateProviderMode() {
		System.setProperty("org.apache.cocoon.mode", "va-provider-dev");
		assertTrue(ModeHelper.isProviderMode());
	}

	@Test
	public void validateProviderTestMode() {
		System.setProperty("org.apache.cocoon.mode", "va-provider-test");
		assertTrue(ModeHelper.isProviderMode());
	}
	
	@Test
	public void validateDefaultMode() {
		System.setProperty("org.apache.cocoon.mode", "");
		assertTrue(ModeHelper.isVeteranMode());
	}
}
