package com.agilex.healthcare.utility;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

import org.junit.Test;

public class ListHelperTest {
	@Test
	public void getFirstItemFromArray() {
		String [] a = {"x" ,"y"};
		assertEquals("x" , ListHelper.getValue(a, 0));
	}
	@Test
	public void getSecondItemFromArray() {
		String [] a = {"x" ,"y"};
		assertEquals("y" , ListHelper.getValue(a, 1));
	}
	@Test
	public void getLastItemFromArray() {
		String [] a = {"x" ,"y","z"};
		assertEquals("z" , ListHelper.getValue(a, 2));
	}
	@Test
	public void getItemFromArrayBeyondBounds() {
		String [] a = {"x" ,"y"};
		assertNull(  ListHelper.getValue(a, 2));
	}
	@Test
	public void getItemFromEmptyArray() {
		String [] a = {};
		assertNull( ListHelper.getValue(a, 2));
	}
	@Test
	public void getItemFromNull() {
		assertNull( ListHelper.getValue(null, 2));
	}

}
