package com.agilex.healthcare.utility;

import static org.junit.Assert.assertEquals;

import javax.xml.bind.JAXBException;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.Allergy;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentQuestion;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResponse;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResponses;

public class JavaObjectSerializationDemoTest {

	@Test
	public void serializeAllergy() throws JAXBException {
		Allergy allergy = new Allergy();
		allergy.setSubstance("dust");
		allergy.setNote("this patient needs to clean their house because they are allergic to dust");
		allergy.setUniqueId("20151");
		allergy.setSeverity("MILD");

		System.out.println("allergy as xml => " + ObjectSerializer.serializeAsXml(allergy));
		System.out.println("allergy as json => " + ObjectSerializer.serializeAsJson(allergy));
	}

	@Test
	public void deserializeAllergy() throws JAXBException {
		Allergy allergy = new Allergy();
		allergy.setSubstance("dust");
		allergy.setNote("this patient needs to clean their house because they are allergic to dust");
		allergy.setUniqueId("20151");
		allergy.setSeverity("MILD");

		String xml = ObjectSerializer.serializeAsXml(allergy);

		Allergy deserializedAllergy = ObjectSerializer.deserializeFromXml(xml, Allergy.class);
		assertEquals(allergy.getNote(), deserializedAllergy.getNote());
		assertEquals(allergy.getUniqueId(), deserializedAllergy.getUniqueId());
	}

	@Test
	public void serializeAssessmentResult() throws JAXBException {
		AssessmentResponses responses = new AssessmentResponses();
		AssessmentResponse response = new AssessmentResponse();
		AssessmentQuestion question = new AssessmentQuestion();
		question.setPrompt("how are you?");
		response.setQuestion(question);
		responses.add(response);

		System.out.println("allergy as xml => " + ObjectSerializer.serializeAsXml(responses));
		System.out.println("allergy as json => " + ObjectSerializer.serializeAsJson(responses));
	}

}
