package com.agilex.healthcare.utility;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

public class IsNumericCalculatorTest {
	@Test
	public void singleDigit1() {
		assertEquals(true, IsNumericCalculator.isNumeric("1"));
	}

	@Test
	public void singleDigit2() {
		assertEquals(true, IsNumericCalculator.isNumeric("2"));
	}

	@Test
	public void singleDigit3() {
		assertEquals(true, IsNumericCalculator.isNumeric("3"));
	}

	@Test
	public void singleDigit4() {
		assertEquals(true, IsNumericCalculator.isNumeric("4"));
	}

	@Test
	public void singleDigit5() {
		assertEquals(true, IsNumericCalculator.isNumeric("5"));
	}

	@Test
	public void singleDigit6() {
		assertEquals(true, IsNumericCalculator.isNumeric("6"));
	}

	@Test
	public void singleDigit7() {
		assertEquals(true, IsNumericCalculator.isNumeric("7"));
	}

	@Test
	public void singleDigit8() {
		assertEquals(true, IsNumericCalculator.isNumeric("8"));
	}

	@Test
	public void singleDigit9() {
		assertEquals(true, IsNumericCalculator.isNumeric("9"));
	}

	@Test
	public void singleDigit0() {
		assertEquals(true, IsNumericCalculator.isNumeric("0"));
	}

	@Test
	public void zeroWithSingleDecimal() {
		assertEquals(true, IsNumericCalculator.isNumeric("0.1"));
	}

	@Test
	public void zeroWithMultipleDecimal() {
		assertEquals(true, IsNumericCalculator.isNumeric("0.12"));
	}

	@Test
	public void period() {
		assertEquals(false, IsNumericCalculator.isNumeric("."));
	}

	@Test
	public void periodNumber() {
		assertEquals(true, IsNumericCalculator.isNumeric(".5"));
	}

	@Test
	public void x() {
		assertEquals(false, IsNumericCalculator.isNumeric("x"));
	}

	@Test
	public void greaterThan() {
		assertEquals(false, IsNumericCalculator.isNumeric(">5"));
	}

	@Test
	public void lessThan() {
		assertEquals(false, IsNumericCalculator.isNumeric("<5"));
	}

	@Test
	public void withSpace() {
		assertEquals(true, IsNumericCalculator.isNumeric(" 0.5 "));
	}
}
