package com.agilex.healthcare.utility;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

public class IntegerParserTest {
	@Test
	public void parseNumber() {
		runParseTest("1", 0, 1);
	}

	@Test
	public void parseAnotherNumber() {
		runParseTest("2", 0, 2);
	}

	@Test
	public void parseNull() {
		runParseTest(null, 1, 1);
	}

	@Test
	public void parseBlank() {
		runParseTest("", 1, 1);
	}

	@Test
	public void parseInvalid() {
		runParseTest("x", 1, 1);
	}

	private void runParseTest(String input, int defaultValue, int expectedValue) {
		Integer parsedInteger = IntegerParser.parseInteger(input, defaultValue);
		assertEquals((int) expectedValue, (int) parsedInteger);
	}
}
