package com.agilex.healthcare.utility;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import org.apache.commons.codec.binary.Hex;
import org.junit.Ignore;
import org.junit.Test;

public class HasherTest {
	private static final int iterations = 1000000;
	private final String originalValue = "http://192.168.25.130:7002/MobileHealthPlatformWeb/rest/patients?searchstring=smith";

	@Ignore
	public void nativeHashWithCachePerformanceTest() throws NoSuchAlgorithmException {
		MessageDigest digest = MessageDigest.getInstance("SHA-1");
		Hex hexEncoder = new Hex();

		for (int i = 0; i <= iterations; i++) {
			String value = originalValue + i;
			String result;
			try {
				digest.reset();
				byte[] byteResult = digest.digest(value.getBytes("UTF-8"));
				byte[] hexarray = hexEncoder.encode(byteResult);
				result = new String(hexarray);
			} catch (UnsupportedEncodingException e) {
				throw new RuntimeException("Failed to convert hash to string", e);
			}
			System.out.println(result);
		}
	}

	@Ignore
	public void nativeHashWithoutCachePerformanceTest() throws NoSuchAlgorithmException {

		for (int i = 0; i <= iterations; i++) {
			MessageDigest digest = MessageDigest.getInstance("SHA-1");
			Hex hexEncoder = new Hex();

			String value = originalValue + i;
			String result;
			try {
				digest.reset();
				byte[] byteResult = digest.digest(value.getBytes("UTF-8"));
				byte[] hexarray = hexEncoder.encode(byteResult);
				result = new String(hexarray);
			} catch (UnsupportedEncodingException e) {
				throw new RuntimeException("Failed to convert hash to string", e);
			}
			System.out.println(result);

		}
	}

	@Ignore
	public void hasherTestWithoutCachePerformanceTest() {
		for (int i = 0; i <= iterations; i++) {
			String value = originalValue + i;
			Hasher hasher = new Hasher();
			String result = hasher.hashStringToString(value);
			System.out.println(result);

		}
	}

	@Ignore
	public void hasherTestWithCachePerformanceTest() {
		Hasher hasher = new Hasher();
		for (int i = 0; i <= iterations; i++) {
			String value = originalValue + i;
			String result = hasher.hashStringToString(value);
			System.out.println(result);

		}
	}

	@Test
	public void sameInputSameHash() {
		Hasher hasher = new Hasher();
		String input = "http://192.168.25.130:7002/MobileHealthPlatformWeb/rest/patients?searchstring=smith";

		String result1 = hasher.hashStringToString(input);
		String result2 = hasher.hashStringToString(input);

		assertEquals(result1, result2);
	}

	@Test
	public void hashDifferentInputsResultsInDifferentValues() {
		Hasher hasher = new Hasher();
		String input1 = "http://192.168.25.130:7002/MobileHealthPlatformWeb/rest/patients?searchstring=smith";
		String input2 = "http://192.168.25.130:7002/MobileHealthPlatformWeb/rest/patients?searchstring=smith&p2";
		String input3 = "http://192.168.25.130:7002/MobileHealthPlatformWeb/rest/patients?searchstring=younger";

		String result1 = hasher.hashStringToString(input1);
		String result2 = hasher.hashStringToString(input2);
		String result3 = hasher.hashStringToString(input3);

		System.out.println(String.format("%s=>%s", input1, result1));
		System.out.println(String.format("%s=>%s", input2, result2));
		System.out.println(String.format("%s=>%s", input3, result3));

		assertFalse(result1.contentEquals(result2));
		assertFalse(result1.contentEquals(result3));
	}

}
