package com.agilex.healthcare.utility;

import static org.junit.Assert.assertEquals;

import java.util.Collections;

import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.DietEntries;
import com.agilex.healthcare.mobilehealthplatform.domain.DietEntry;

public class DietEntryComparatorTest {
	private DietEntry mealEntry1;
	private DietEntry mealEntry2;
	private DietEntry mealEntry3;
	private DietEntry mealEntry4;
	private DietEntryTimeComparator comparator;

	
	@Before
	public void setup() {

		mealEntry1 = new DietEntry();
		mealEntry1.setEntryDate(DateHelper.parse("10/15/2011 10:00 AM", "MM/dd/yyyy hh:mm a"));
		mealEntry2 = new DietEntry();
		mealEntry2.setEntryDate(DateHelper.parse("10/12/2011 11:00 AM", "MM/dd/yyyy hh:mm a"));
		mealEntry3 = new DietEntry();
		mealEntry3.setEntryDate(DateHelper.parse("10/15/2011 9:00 AM", "MM/dd/yyyy hh:mm a"));
		mealEntry4 = new DietEntry();
		mealEntry4.setEntryDate(DateHelper.parse("10/15/2011 11:59 AM", "MM/dd/yyyy hh:mm a"));
		
		
		comparator = new DietEntryTimeComparator();
	}

	@Test
	public void validateVitalsAreSortedByTimeInAscendingOrder(){
		
		DietEntries mealEntries = new DietEntries();
		mealEntries.add(mealEntry1);
		mealEntries.add(mealEntry2);
		mealEntries.add(mealEntry3);
		mealEntries.add(mealEntry4);

		
		Collections.sort(mealEntries, comparator);
		
		assertEquals(mealEntry2.getEntryDate(), mealEntries.get(0).getEntryDate());
		assertEquals(mealEntry3.getEntryDate(), mealEntries.get(1).getEntryDate());
		assertEquals(mealEntry1.getEntryDate(), mealEntries.get(2).getEntryDate());
		assertEquals(mealEntry4.getEntryDate(), mealEntries.get(3).getEntryDate());
		
	}

	@Test
	public void validateVitalsAreSortedByTimeInDescendingOrder(){
		
		DietEntries mealEntries = new DietEntries();
		
		mealEntries.add(mealEntry1);
		mealEntries.add(mealEntry2);
		mealEntries.add(mealEntry3);
		mealEntries.add(mealEntry4);
		
		Collections.sort(mealEntries, comparator);
		Collections.reverse(mealEntries);
		
		assertEquals(mealEntry4.getEntryDate(), mealEntries.get(0).getEntryDate());
		assertEquals(mealEntry1.getEntryDate(), mealEntries.get(1).getEntryDate());
		assertEquals(mealEntry3.getEntryDate(), mealEntries.get(2).getEntryDate());
		assertEquals(mealEntry2.getEntryDate(), mealEntries.get(3).getEntryDate());
		
	}}
