package com.agilex.healthcare.utility;

import static org.junit.Assert.assertEquals;

import java.util.*;

import org.junit.*;


public class DateHelperTest {
	@Test
	public void testBeginningOfToday() {

		Calendar today = Calendar.getInstance();
		Calendar midnightToCheck = new GregorianCalendar();
		midnightToCheck.setTime(DateHelper.beginOfDate(today.getTime()));
		
		assertEquals(0, midnightToCheck.get(Calendar.HOUR));
		assertEquals(0, midnightToCheck.get(Calendar.MINUTE));
		assertEquals(0, midnightToCheck.get(Calendar.SECOND));
		assertEquals(0, midnightToCheck.get(Calendar.MILLISECOND));
		
		assertEquals(today.get(Calendar.MONTH), midnightToCheck.get(Calendar.MONTH));
		assertEquals(today.get(Calendar.DAY_OF_MONTH), midnightToCheck.get(Calendar.DAY_OF_MONTH));
		assertEquals(today.get(Calendar.DAY_OF_YEAR), midnightToCheck.get(Calendar.DAY_OF_YEAR));
	}
	
	@Test
	public void validateDeltaInDays() {
		assertEquals(1, DateHelper.calculateDeltaInDays(DateHelper.parseDate("01/01/2012"), DateHelper.parseDate("01/02/2012")));
	}
	
	@Test
	public void validateNegativeDeltaInDays() {
		assertEquals(-1, DateHelper.calculateDeltaInDays(DateHelper.parseDate("01/02/2012"), DateHelper.parseDate("01/01/2012")));
	}
	
	@Test
	public void validateGreaterThan() {
		Assert.assertTrue(DateHelper.greaterThanOrEqual(new Date(), DateHelper.getYesterday()));
	}
	
    @Test
    public void validateParseDateTime() {
            Date date = DateHelper.parseDateTime("01/02/2012 00:00:00");
            System.out.println(date);
            date = DateHelper.parseDateTime("01/02/2012 23:59:59");
            System.out.println(date);
    }
	
}
