package com.agilex.healthcare.utility;

import static org.junit.Assert.assertEquals;

import java.util.Date;

import org.junit.Test;

public class DateHelperDurationTest {

	@Test
	public void calculateDeltaInMillisBetweenSameDate() {

		Date a = DateHelper.parseDateTime("12/1/2000 01:02:03");

		long delta = DateHelper.calculateDeltaInMillis(a, a);
		assertEquals(0L, delta);
	}

	@Test
	public void calculateDeltaInMillisBetweenTwoDates() {

		Date a = DateHelper.parseDateTime("12/1/2000 01:02:03");
		Date b = DateHelper.parseDateTime("12/1/2000 01:02:04");

		long delta = DateHelper.calculateDeltaInMillis(a, b);
		assertEquals(1000L, delta);
	}

	@Test
	public void calculateDeltaInMillisBetweenTwoDatesWithMinutes() {

		Date a = DateHelper.parseDateTime("12/1/2000 01:02:03");
		Date b = DateHelper.parseDateTime("12/1/2000 01:03:04");

		long delta = DateHelper.calculateDeltaInMillis(a, b);
		assertEquals((1 * 60 + 1) * 1000L, delta);
	}

	@Test
	public void calculateDeltaInYearsBetweenTwoDates() {

		Date a = DateHelper.parseDateTime("12/1/2000 01:02:03");
		Date b = DateHelper.parseDateTime("12/2/2001 01:03:04");

		long delta = DateHelper.calculateDeltaInYears(a, b);
		assertEquals(1L, delta);
	}

	@Test
	public void calculateDeltaInMonthsBetweenTwoDates() {

		Date a = DateHelper.parseDateTime("1/1/2000 01:02:03");
		Date b = DateHelper.parseDateTime("3/1/2000 01:03:04");

		long delta = DateHelper.calculateDeltaInMonth(a, b);
		assertEquals(2L, delta);
	}

	@Test
	public void calculateDeltaInMonthsBetweenTwoDatesDifferentYears() {

		Date a = DateHelper.parseDateTime("1/1/2000 01:02:03");
		Date b = DateHelper.parseDateTime("3/1/2001 01:03:04");

		long delta = DateHelper.calculateDeltaInMonth(a, b);
		assertEquals(14L, delta);
	}
}
