package com.agilex.healthcare.utility;

import static org.junit.Assert.*;
import java.util.Date;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.DOBDate;


public class DOBDateTest {
	
	@Test 
	public void validateCorrectDateIsReturned(){
		DOBDate dob = new DOBDate("yyyyMMdd", "20100310");
		assertEquals(DateHelper.parse("20100310", "yyyyMMdd"), dob.getDate());
	} 
	
	@Test 
	public void validateCorrectDateIsReturnedInStringFormat(){
		DOBDate dob = new DOBDate("yyyyMMdd", "20100310");
		assertEquals("20100310", dob.toString());
	} 
	
	@Test 
	public void validateCorrectDateIsReturnedWhenCreatedWithYearOnly(){
		DOBDate dob = new DOBDate("yyyy", "2010");
		assertEquals(DateHelper.parse("20100101", "yyyyMMdd"), dob.getDate());
	} 
	
	@Test 
	public void validateCorrectDateIsReturnedInStringFormatWhenCreatedWithYearOnly(){
		DOBDate dob = new DOBDate("yyyy", "2010");
		assertEquals("2010", dob.toString());
	} 
	
	@Test 
	public void validateCorrectDateIsReturnedWhenCreatedWithYearMonth(){
		DOBDate dob = new DOBDate("yyyyMM", "201003");
		assertEquals(DateHelper.parse("20100301", "yyyyMMdd"), dob.getDate());
	} 
	
	@Test 
	public void validateCorrectDateIsReturnedInStringFormatWhenCreatedWithYearMonth(){
		DOBDate dob = new DOBDate("yyyyMM", "201003");
		assertEquals("201003", dob.toString());
	} 

	@Test
	public void checkWhetherConstructorHandlesInvalidDate(){
        DOBDate dob = new DOBDate("yyyyMM", "2010");
        assertFalse(dob.isValid());
        assertEquals("2010", dob.toString());
        assertNull(dob.getDate());
    }

	@Test
	public void checkWhetherConstructorHandlesInvalidFormat(){
        DOBDate dob = new DOBDate("yyyyMMxyz", "2010");
        assertFalse(dob.isValid());
        assertEquals("2010", dob.toString());
        assertNull(dob.getDate());
    }
	
	
	@Test
	public void validateCorrectDOBisCreatedWhenInputisADateObject(){
		String expectedDate = "Apr 01, 2008";
		Date dob = DateHelper.parse(expectedDate, "MMM dd, yyyy");
		DOBDate dobDate  = new DOBDate(dob);
		assertEquals(expectedDate, dobDate.toString());
		assertEquals(dob, dobDate.getDate());
	}
	
	@Test
	public void validateCorrectDOBisCreatedWhenInputisAMonthYearDateObject(){
		String dob = "Apr 2008";
		String expectedDate = "Apr 01, 2008";
		String inputDate = "";
 		if (dob.contains(" ")) {
 			inputDate = dob;
 		}
		Date conDate = DateHelper.parse(inputDate, "MMM yyyy");
		DOBDate dobDate  = new DOBDate(conDate);
		assertEquals(expectedDate, dobDate.toString());
	}
	
	@Test
	public void validateDOBCreationWhenInputIsNullDate(){
        DOBDate dob = new DOBDate(null);
        assertFalse(dob.isValid());
        assertEquals("", dob.toString());
        assertNull(dob.getDate());
    }

    @Test
    public void canReadValueInUnknownFormat() {
        String expectedDate = "1950-06-02T00:00:00-07:00";
        DOBDate dobDate  = new DOBDate("yyyy-MM-ddTHH:mm:ssz", expectedDate);
        assertEquals(expectedDate, dobDate.toString());
        assertFalse(dobDate.isValid());
    }

    @Test
    public void canReadGenericDateFormat() {
        String expectedDate = "1950-06-02";
        DOBDate dobDate  = new DOBDate("yyyy-MM-dd", expectedDate);
        assertEquals(expectedDate, dobDate.toString());
        assertTrue(dobDate.isValid());
    }
}
