package com.agilex.healthcare.utility;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNull;

import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.DOBDate;

public class DOBDateMarshallerTest {

	private String expectedDateStr;
	private DOBDateMarshaller dobDateMarshaller;

	@Before
	public void setup() {
		dobDateMarshaller = new DOBDateMarshaller();
	}

	@Test
	public void marshaDOBDate() throws Exception {
	    expectedDateStr = "Apr 03, 2010";
		DOBDate dobDate = new DOBDate("MMM dd, yyyy", expectedDateStr);
		String actualDateStr = dobDateMarshaller.marshal(dobDate);
		assertEquals(expectedDateStr, actualDateStr);
	}

	@Test
	public void serializeSimpleDateMar102010() throws Exception {
		expectedDateStr = "Mar 10, 2010";
		DOBDate dobDate = new DOBDate("MMM dd, yyyy", expectedDateStr);
		String actualDateStr = dobDateMarshaller.marshal(dobDate);
		assertEquals(expectedDateStr, actualDateStr);
	}

	@Test
	public void deserializeSimpleDateJan022010() throws Exception {
		expectedDateStr = "Jan 01, 2010";
		DOBDate unmarshalledDate = dobDateMarshaller.unmarshal(expectedDateStr);
		assertEquals(expectedDateStr, unmarshalledDate.toString());
	}

	@Test
	public void deserializeSimpleDateMar102010() throws Exception {
		expectedDateStr = "Mar 10, 2010";
		DOBDate unmarshalledDate = dobDateMarshaller.unmarshal(expectedDateStr);
		assertEquals(expectedDateStr, unmarshalledDate.toString());

	}

	@Test
	public void validateSerializeWorksWithNullInput() throws Exception {
		String dobDate = dobDateMarshaller.marshal(null);
		assertNull(dobDate);
	}

	@Test
	public void validateDeSerializeWorksWithNullInput() throws Exception {
		DOBDate dobDate = dobDateMarshaller.unmarshal(null);
		assertNull(dobDate);
	}

	@Test
	public void validateDeSerializeWorksWithEmptyStringInput() throws Exception {
		DOBDate dobDate = dobDateMarshaller.unmarshal("");
		assertNull(dobDate);
	}

	@Test()
	public void validateUnMarshallThrowsExceptionForInvalidInput() throws Exception {
        expectedDateStr = "398592384";
        DOBDate dobDate = dobDateMarshaller.unmarshal(expectedDateStr);
        assertFalse(dobDate.isValid());
        assertEquals(expectedDateStr, dobDate.toString());
        assertNull(dobDate.getDate());
    }

}
