package com.agilex.healthcare.utility;

import static org.junit.Assert.assertEquals;

import java.beans.PropertyEditorSupport;

import org.junit.Test;

public class CustomDOBDateEditorTest {
	@Test
	public void getAndsetDateFormat1() {
		PropertyEditorSupport editor = new CustomDOBDateEditor("mm/dd/yyyy");
		editor.setAsText("01/02/2006");
		assertEquals("Jan 02, 2006", editor.getAsText());
	}

	@Test(expected = Exception.class)
	public void getAndsetDateInvalidFormat() {
		PropertyEditorSupport editor = new CustomDOBDateEditor("mm/dd/yyyy");
		editor.setAsText("01-02-2006");
	}

	@Test
	public void getAndsetDateFormat2() {
		PropertyEditorSupport editor = new CustomDOBDateEditor("mm-dd-yyyy");
		editor.setAsText("01-02-2006");
		assertEquals("Jan 02, 2006", editor.getAsText());
	}

	@Test
	public void nullDate() {
		PropertyEditorSupport editor = new CustomDOBDateEditor("mm-dd-yyyy");
		assertEquals(null, editor.getAsText());
	}
}
