package com.agilex.healthcare.utility;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

public class BooleanParserTest {

	@Test
	public void findLowerTrue() {
		assertEquals(true, BooleanParser.parse("true"));
	}

	@Test
	public void findUpperTrue() {
		assertEquals(true, BooleanParser.parse("TrUe"));
	}

	@Test
	public void findLowerFalse() {
		assertEquals(false, BooleanParser.parse("false"));
	}

	@Test
	public void findUpperFalse() {
		assertEquals(false, BooleanParser.parse("FaLsE"));
	}

	@Test
	public void find1() {
		assertEquals(true, BooleanParser.parse("1"));
	}

	@Test
	public void find0() {
		assertEquals(false, BooleanParser.parse("0"));
	}

	@Test
	public void findOn() {
		assertEquals(true, BooleanParser.parse("on"));
	}

	@Test
	public void findOff() {
		assertEquals(false, BooleanParser.parse("off"));
	}

	@Test
	public void findYes() {
		assertEquals(true, BooleanParser.parse("yEs"));
	}

	@Test
	public void findNo() {
		assertEquals(false, BooleanParser.parse("nO"));
	}

	@Test(expected = IllegalArgumentException.class)
	public void exceptionOnNoMatch() {
		BooleanParser.parse("not a boolean");
	}

	public void useDefaultOfTrue() {
		assertEquals(true, BooleanParser.parse("not a boolean", true));
	}

	public void useDefaultOfFalse() {
		assertEquals(false, BooleanParser.parse("not a boolean", false));
	}
}
