package com.agilex.healthcare.utility;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

public class ArrayAppenderTest {

	@Test
	public void appendItem() {
		String[] input = { "a", "b" };
		String[] result = ArrayAppender.append(input, "c");
		String[] expectedResult = { "a", "b", "c" };

		assertArrayEquals(expectedResult, result);
	}

	@Test
	public void appendTwoItems() {
		String[] input = { "a", "b" };
		String[] result = ArrayAppender.append(input, "c","d");
		String[] expectedResult = { "a", "b", "c" ,"d"};

		assertArrayEquals(expectedResult, result);
	}

	@Test
	public void appendItemToEmptyArray() {
		String[] input = {};
		String[] result = ArrayAppender.append(input, "a");
		String[] expectedResult = { "a" };

		assertArrayEquals(expectedResult, result);
	}

	private void assertArrayEquals(String[] expected, String[] actual) {
		assertEquals("Lengths of arrays do not equal", expected.length, actual.length);
		for (int i = 0; i < expected.length; i++) {
			assertEquals("Element " + i + " does not equal", expected[i], actual[i]);
		}
	}
}
