package com.agilex.healthcare.mobilehealthplatform.validator.preference;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import java.util.LinkedList;
import java.util.List;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientPreference;
import com.agilex.healthcare.mobilehealthplatform.domain.ValidationResult;

public class PreferenceValidatorTest {

	PreferenceValidator validator = new PreferenceValidator();

	@Test
	public void verifyAppointmentRequestValid() {
		PatientPreference pref = createValidPatientPref();
		
		ValidationResult<PatientPreference> result = validator.validate(pref);
		assertEquals(true, result.isValid());
	}
	
	@Test
	public void verifyInvalidMinLengthPhoneNumber() {
		PatientPreference pref = createValidPatientPref();
		pref.setTextMsgPhNumber("5555-5555");
		
		ValidationResult<PatientPreference> result = validator.validate(pref);
		assertEquals(false, result.isValid());
	}
	
	@Test
	public void verifyInvalidEmail() {
		List<String> invalidEmails = new LinkedList<String>();
		invalidEmails.add("Abc.example.com");
		invalidEmails.add("Abc.@example.com");
		invalidEmails.add("Abc..123@example.com");
		invalidEmails.add(".test@example.com");
		
		for (String invalidEmail : invalidEmails) {
			PatientPreference pref = createValidPatientPref();
			pref.setEmailAddress(invalidEmail);

			ValidationResult<PatientPreference> result = validator.validate(pref);			
			System.out.println(invalidEmail);
			assertEquals(false, result.isValid());
		}
	}

    @Test
    public void verifyNeverNotificationFrequency(){
        PatientPreference pref = createValidPatientPref();
        pref.setNotificationFrequency("Never");

        ValidationResult<PatientPreference> result = validator.validate(pref);
        assertTrue(result.isValid());
    }
    @Test
    public void verifyEachNotificationFrequency(){
        PatientPreference pref = createValidPatientPref();
        pref.setNotificationFrequency("Each new message");

        ValidationResult<PatientPreference> result = validator.validate(pref);
        assertTrue(result.isValid());
    }

    @Test
    public void verifyDailyNotificationFrequency(){
        PatientPreference pref = createValidPatientPref();
        pref.setNotificationFrequency("Daily");

        ValidationResult<PatientPreference> result = validator.validate(pref);
        assertTrue(result.isValid());
    }

    @Test
    public void verifyInvalidFrequency(){
        PatientPreference pref = createValidPatientPref();
        pref.setNotificationFrequency("Bogus");

        ValidationResult<PatientPreference> result = validator.validate(pref);
        assertFalse(result.isValid());
    }
	private PatientPreference createValidPatientPref() {
		
		String email = "test@agilex.com";
		String phoneNumber = "+1 (555) 555-5555 x55.55";
		PatientPreference testPref = new PatientPreference();
		testPref.setEmailAddress(email);
		testPref.setTextMsgPhNumber(phoneNumber);
        testPref.setNotificationFrequency("Never");
		
		return testPref;
	}

	
}
