package com.agilex.healthcare.mobilehealthplatform.validator.diet;

import static org.junit.Assert.assertEquals;

import java.util.Date;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.DietEntry;
import com.agilex.healthcare.mobilehealthplatform.domain.ValidationResult;

public class DietValidatorTest {
	DietValidator validator = new DietValidator();
	private String notes = "Java is a programming";


	@Test
	public void verifyNormalMealEntryValid() {
		DietEntry mealEntry = createMealEntry("1", "1", "1", "1");
		ValidationResult<DietEntry> result = validator.validate(mealEntry);
		assertEquals(true, result.isValid());
	}

	@Test
	public void verifyZeroMealEntryValid() {
		DietEntry mealEntry = createMealEntry("0", "0", "0", "0");
		ValidationResult<DietEntry> result = validator.validate(mealEntry);
		assertEquals(true, result.isValid());
	}

	@Test
	public void verifyMealEntryCaloriesNegNotValid() {
		DietEntry mealEntry = createMealEntry("-1", "0", "0", "0");
		ValidationResult<DietEntry> result = validator.validate(mealEntry);
		assertEquals(false, result.isValid());
	}
	
	@Test
	public void verifyMealEntryNegNotValid() {
		DietEntry mealEntry = createMealEntry("0", "-1", "0", "0");
		ValidationResult<DietEntry> result = validator.validate(mealEntry);
		assertEquals(false, result.isValid());
	}
	
	@Test
	public void verifyMealEntryFatNegNotValid() {
		DietEntry mealEntry = createMealEntry("0", "0", "-1", "0");
		ValidationResult<DietEntry> result = validator.validate(mealEntry);
		assertEquals(false, result.isValid());
	}
	
	@Test
	public void verifyMealEntryProteinNegNotValid() {
		DietEntry mealEntry = createMealEntry("0", "0", "0", "-1");
		ValidationResult<DietEntry> result = validator.validate(mealEntry);
		assertEquals(false, result.isValid());
	}
	
	@Test
	public void verifyMealEntryCaloriesNullIsValid() {
		DietEntry mealEntry = createMealEntry(null, "0", "0", "0");
		ValidationResult<DietEntry> result = validator.validate(mealEntry);
		assertEquals(true, result.isValid());
	}
	
	@Test
	public void verifyMealEntryNullIsValid() {
		DietEntry mealEntry = createMealEntry("0", null, "0", "0");
		ValidationResult<DietEntry> result = validator.validate(mealEntry);
		assertEquals(true, result.isValid());
	}
	
	@Test
	public void verifyMealEntryFatNullIsValid() {
		DietEntry mealEntry = createMealEntry("0", "0", null, "0");
		ValidationResult<DietEntry> result = validator.validate(mealEntry);
		assertEquals(true, result.isValid());
	}
	
	@Test
	public void verifyMealEntryProteinNullIsValid() {
		DietEntry mealEntry = createMealEntry("0", "0", "0", null);
		ValidationResult<DietEntry> result = validator.validate(mealEntry);
		assertEquals(true, result.isValid());
	}
	
	@Test
	public void verifyMealEntryCaloriesEmptyIsValid() {
		DietEntry mealEntry = createMealEntry("", "0", "0", "0");
		ValidationResult<DietEntry> result = validator.validate(mealEntry);
		assertEquals(true, result.isValid());
	}
	
	@Test
	public void verifyMealEntryEmptyIsValid() {
		DietEntry mealEntry = createMealEntry("0", "", "0", "0");
		ValidationResult<DietEntry> result = validator.validate(mealEntry);
		assertEquals(true, result.isValid());
	}
	
	@Test
	public void verifyMealEntryFatEmptyIsValid() {
		DietEntry mealEntry = createMealEntry("0", "0", "", "0");
		ValidationResult<DietEntry> result = validator.validate(mealEntry);
		assertEquals(true, result.isValid());
	}
	
	@Test
	public void verifyMealEntryProteinEmptyIsValid() {
		DietEntry mealEntry = createMealEntry("0", "0", "0", "");
		ValidationResult<DietEntry> result = validator.validate(mealEntry);
		assertEquals(true, result.isValid());
	}
	
	@Test
	public void verifyMealEntryCaloriesAlphaNotValid() {
		DietEntry mealEntry = createMealEntry("XYZ", "0", "0", "0");
		ValidationResult<DietEntry> result = validator.validate(mealEntry);
		assertEquals(false, result.isValid());
	}
	
	@Test
	public void verifyMealEntryAlphaNotValid() {
		DietEntry mealEntry = createMealEntry("0", "XYZ", "0", "0");
		ValidationResult<DietEntry> result = validator.validate(mealEntry);
		assertEquals(false, result.isValid());
	}
	
	@Test
	public void verifyMealEntryFatAlphaNotValid() {
		DietEntry mealEntry = createMealEntry("0", "0", "XYZ", "0");
		ValidationResult<DietEntry> result = validator.validate(mealEntry);
		assertEquals(false, result.isValid());
	}
	
	@Test
	public void verifyMealEntryProteinAlphaNotValid() {
		DietEntry mealEntry = createMealEntry("0", "0", "0", "XYZ");
		ValidationResult<DietEntry> result = validator.validate(mealEntry);
		assertEquals(false, result.isValid());
	}

	@Test
	public void verifyMealEntryCaloriesOverMaxNotValid() {
		DietEntry mealEntry = createMealEntry("10000", "0", "0", "0");
		ValidationResult<DietEntry> result = validator.validate(mealEntry);
		assertEquals(false, result.isValid());
	}
	
	@Test
	public void verifyMealEntryOverMaxNotValid() {
		DietEntry mealEntry = createMealEntry("0", "10000", "0", "0");
		ValidationResult<DietEntry> result = validator.validate(mealEntry);
		assertEquals(false, result.isValid());
	}
	
	@Test
	public void verifyMealEntryFatOverMaxNotValid() {
		DietEntry mealEntry = createMealEntry("0", "0", "10000", "0");
		ValidationResult<DietEntry> result = validator.validate(mealEntry);
		assertEquals(false, result.isValid());
	}
	
	@Test
	public void verifyMealEntryProteinOverMaxNotValid() {
		DietEntry mealEntry = createMealEntry("0", "0", "0", "10000");
		ValidationResult<DietEntry> result = validator.validate(mealEntry);
		assertEquals(false, result.isValid());
	}
	
	private DietEntry createMealEntry(String calories, String carbs, String fat, String protein) {
		DietEntry mealEntry = new DietEntry();
		mealEntry.setNotes(notes);
		mealEntry.setEntryDate(new Date());

		mealEntry.setCalories(calories);
		mealEntry.setCarbs(carbs);
		mealEntry.setFat(fat);
		mealEntry.setProtein(protein);
		
		return mealEntry;
	}
}
