package com.agilex.healthcare.mobilehealthplatform.domain.sorting;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.LabTest;

public class LabTestComparatorTest {

	private LabTestComparator comparator = new LabTestComparator();
	
	@Test
	public void testSimpleAlphaLessThan() {
		LabTest left = createLabTest("A", "A");
		LabTest right = createLabTest("B", "B");
		
		assertEquals(-1, comparator.compare(left, right));
	}
	
	@Test
	public void testSimpleEquals() {
		LabTest left = createLabTest("A", "A");
		LabTest right = createLabTest("A", "A");
		
		assertEquals(0, comparator.compare(left, right));
	}
	
	@Test
	public void testSimpleAlphaGreaterThan() {
		LabTest left = createLabTest("B", "B");
		LabTest right = createLabTest("A", "A");
		
		assertEquals(1, comparator.compare(left, right));
	}
	
	public LabTest createLabTest(String testName, String specimenName) {
		LabTest labTest = new LabTest();
		labTest.setTestname(testName);
		labTest.setSpecimenName(specimenName);
		
		return labTest;
	}
	
}
