package com.agilex.healthcare.mobilehealthplatform.domain;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

public class VitalEntryTest {

	@Test
	public void getObservationWithSingleEntry() {
		VitalEntry entry = new VitalEntry();
		entry.getVitalObservations().add(createObservation("t", "v"));
		VitalObservation obs = entry.getObservationByType("t");
		assertEquals("v", obs.getValue());
	}

	@Test
	public void getFirstObservationWithMultipleEntries() {
		VitalEntry entry = new VitalEntry();
		entry.getVitalObservations().add(createObservation("t1", "v1"));
		entry.getVitalObservations().add(createObservation("t2", "v2"));
		entry.getVitalObservations().add(createObservation("t3", "v3"));
		VitalObservation obs = entry.getObservationByType("t1");
		assertEquals("v1", obs.getValue());
	}

	@Test
	public void getSecondObservationWithMultipleEntries() {
		VitalEntry entry = new VitalEntry();
		entry.getVitalObservations().add(createObservation("t1", "v1"));
		entry.getVitalObservations().add(createObservation("t2", "v2"));
		entry.getVitalObservations().add(createObservation("t3", "v3"));
		VitalObservation obs = entry.getObservationByType("t2");
		assertEquals("v2", obs.getValue());
	}

	@Test
	public void getThirdObservationWithMultipleEntries() {
		VitalEntry entry = new VitalEntry();
		entry.getVitalObservations().add(createObservation("t1", "v1"));
		entry.getVitalObservations().add(createObservation("t2", "v2"));
		entry.getVitalObservations().add(createObservation("t3", "v3"));
		VitalObservation obs = entry.getObservationByType("t3");
		assertEquals("v3", obs.getValue());
	}

	@Test
	public void getObservationValue() {
		VitalEntry entry = new VitalEntry();
		entry.getVitalObservations().add(createObservation("t1", "v1"));
		entry.getVitalObservations().add(createObservation("t2", "v2"));
		entry.getVitalObservations().add(createObservation("t3", "v3"));
		assertEquals("v2", entry.getObservationValueByType("t2"));
	}

	@Test
	public void getObservationValueNoMatch() {
		VitalEntry entry = new VitalEntry();
		entry.getVitalObservations().add(createObservation("t1", "v1"));
		entry.getVitalObservations().add(createObservation("t2", "v2"));
		entry.getVitalObservations().add(createObservation("t3", "v3"));
		assertEquals(null, entry.getObservationValueByType("X"));
	}

	@Test
	public void getObservationByNullTypeWithNoObservations() {
		VitalEntry entry = new VitalEntry();
		VitalObservation obs = entry.getObservationByType(null);
		assertNull(obs);
	}

	@Test
	public void getObservationByNullTypeWithObservations() {
		VitalEntry entry = new VitalEntry();
		VitalObservation obs = createObservation("t", "v");
		entry.getVitalObservations().add(obs);
		obs = entry.getObservationByType(null);
		assertNull(obs);
	}

	@Test
	public void getObservationValueByTypeWithMultiplePossibleResults() {
		VitalEntry entry = new VitalEntry();
		entry.getVitalObservations().add(createObservation("t1", "v1"));
		entry.getVitalObservations().add(createObservation("t2", "v2-A"));
		entry.getVitalObservations().add(createObservation("t2", "v2-B"));
		entry.getVitalObservations().add(createObservation("t3", "v3"));
		assertEquals("v2-A", entry.getObservationValueByType("t2"));
	}

	@Test
	public void getObservationByTest() {
		VitalEntry entry = new VitalEntry();
		entry.setObservationValueByType("t", "v");
		VitalObservation obs = entry.getObservationByType("t");
		assertEquals("v", obs.getValue());
	}

	@Test
	public void getObservationValueByTestNoMatch() {
		VitalEntry entry = new VitalEntry();
		entry.setObservationValueByType("t", "v");
		String obs = entry.getObservationValueByType("X");
		assertEquals(null, obs);
	}

	@Test
	public void getObservationValueByTest() {
		VitalEntry entry = new VitalEntry();
		entry.setObservationValueByType("t", "v");
		String obsValue = entry.getObservationValueByType("t");
		assertEquals("v", obsValue);
	}

	@Test
	public void getObservationByTestNoMatch() {
		VitalEntry entry = new VitalEntry();
		entry.setObservationValueByType("t", "v");
		String obsValue = entry.getObservationValueByType("X");
		assertEquals(null, obsValue);
	}

	@Test
	public void setObservationValueWithMultipleEntriesByTest() {
		VitalEntry entry = new VitalEntry();
		entry.setObservationValueByType("t1", "v1");
		entry.setObservationValueByType("t2", "v2");
		entry.setObservationValueByType("t3", "v3");
		VitalObservation obs = entry.getObservationByType("t2");
		assertEquals("v2", obs.getValue());
	}

	@Test
	public void setObservationValueAsUpdate() {
		VitalEntry entry = new VitalEntry();
		entry.setObservationValueByType("t1", "v1");
		entry.setObservationValueByType("t2", "v2");
		entry.setObservationValueByType("t2", "v3");
		entry.setObservationValueByType("t2", "v4");
		entry.setObservationValueByType("t3", "v3");
		VitalObservation obs = entry.getObservationByType("t2");
		assertEquals("v4", obs.getValue());
		assertEquals(3, entry.getVitalObservations().size());
	}

	private VitalObservation createObservation(String type, String value) {
		VitalObservation obs = new VitalObservation();
		obs.setType(type);
		obs.setValue(value);
		return obs;
	}
	
	@Test
	public void validateVitalsWithOutIdAreNotEqual(){
		VitalEntry vitalEntry1 = new VitalEntry();
		VitalEntry vitalEntry2 = new VitalEntry();
		assertFalse(vitalEntry1.equals(vitalEntry2));
	}

	@Test
	public void validateVitalsWithSameIdsAreEqual(){
		VitalEntry vitalEntry1 = new VitalEntry();
		vitalEntry1.setId("123");
		VitalEntry vitalEntry2 = new VitalEntry();
		vitalEntry2.setId("123");
		assertTrue(vitalEntry1.equals(vitalEntry2));
	}
	
	@Test
	public void vitalEntryIsNotEqualsToNullVitalEntry(){
		VitalEntry vitalEntry1 = new VitalEntry();
		vitalEntry1.setId("123");
		VitalEntry vitalEntry2 = null;
		assertFalse(vitalEntry1.equals(vitalEntry2));
	}
	
	
}
