package com.agilex.healthcare.mobilehealthplatform.domain;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

import com.agilex.healthcare.utility.DateHelper;

public class TimingDtoGetTimingTest {

	private TimingDto getTiming() {
		TimingDto t = new TimingDto();
		t.setStartDate(DateHelper.parseDateTime("1/1/2000 01:02:03"));
		t.setEndDate(DateHelper.parseDateTime("1/1/2000 01:02:05"));
		t.setStartTicks(1000);
		t.setEndTicks(2000);
		t.setTiming(20);
		return t;
	}

	@Test
	public void calculateTimingFromDates() {
		TimingDto t = getTiming();
		t.setTiming(0);
		t.setEndTicks(0);
		assertEquals(2000L, t.getTiming());
	}

	@Test
	public void calculateTimingFromTicks() {
		TimingDto t = getTiming();
		t.setTiming(0);
		assertEquals(1000L, t.getTiming());
	}

	@Test
	public void calculateTimingFromTiming() {
		TimingDto t = getTiming();
		assertEquals(20L, t.getTiming());
	}
}
