package com.agilex.healthcare.mobilehealthplatform.domain;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.Date;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.sorting.PatientSortingAlgorithm;
import com.agilex.healthcare.utility.DateHelper;

public class SortingPatientsTest {
	@Test
	public void comparePatientsAtoB() {
		Patient a = createPatient("Adams", "firstname", DateHelper.parseDate("1/1/1970"), null);
		Patient b = createPatient("Bonds", "firstname", DateHelper.parseDate("1/1/1970"), null);
		assertEquals(PatientSortingAlgorithm.LESS_THAN, a.compareTo(b));
	}

	@Test
	public void comparePatientsBtoA() {
		Patient a = createPatient("Adams", "firstname", DateHelper.parseDate("1/1/1970"), null);
		Patient b = createPatient("Bonds", "firstname", DateHelper.parseDate("1/1/1970"), null);
		assertEquals(PatientSortingAlgorithm.GREATER_THAN, b.compareTo(a));
	}

	@Test
	public void comparePatientsAtoA() {
		Patient a1 = createPatient("Adams", "firstname", DateHelper.parseDate("1/1/1970"), null);
		Patient a2 = createPatient("Adams", "firstname", DateHelper.parseDate("1/1/1970"), null);
		assertEquals(PatientSortingAlgorithm.EQUAL_TO, a1.compareTo(a2));
	}

	public Patient createPatient(String lastname, String firstname, Date dob, String ssn) {
		Patient p = new Patient();
		p.setLastName(lastname);
		p.setFirstName(firstname);
		if (dob != null){
			p.setDateOfBirth(new DOBDate(dob));
		}
		p.setSsn(ssn);
		return p;
	}

	@Test
	public void sortPatientsByLastname() {
		Patient a = createPatient("Adams", "firstname", DateHelper.parseDate("1/1/1970"), null);
		Patient b = createPatient("Bonds", "firstname", DateHelper.parseDate("1/1/1970"), null);
		Patient c = createPatient("       ", "firstname", DateHelper.parseDate("1/1/1970"), null);

		Patients patients = new Patients();
		patients.add(b);
		patients.add(a);
		patients.add(c);

		java.util.Collections.sort(patients);
		assertEquals(a, patients.get(0));
		assertEquals(b, patients.get(1));
		assertEquals(c, patients.get(2));
	}

	@Test
	public void sortPatientsByFirstname() {
		Patient a = createPatient("Adams", "Adam", DateHelper.parseDate("1/1/1970"), null);
		Patient b = createPatient("Adams", "     ", DateHelper.parseDate("1/1/1970"), null);
		Patient c = createPatient("Adams", "Charlie", DateHelper.parseDate("1/1/1970"), null);

		Patients patients = new Patients();
		patients.add(b);
		patients.add(a);
		patients.add(c);

		java.util.Collections.sort(patients);
		assertEquals(a, patients.get(0));
		assertEquals(b, patients.get(1));
		assertEquals(c, patients.get(2));
	}

	@Test
	public void sortPatientsWithSameData() {
		Patient a = createPatient("Adams", "Adam", DateHelper.parseDate("1/1/1970"), null);
		Patient b = createPatient("Adams", "     ", DateHelper.parseDate("1/1/1970"), null);
		Patient c = createPatient("Adams", "     ", DateHelper.parseDate("1/1/1970"), null);
		Patient d = createPatient("Adams", "Charlie", DateHelper.parseDate("1/1/1970"), null);

		Patients patients = new Patients();
		patients.add(c);
		patients.add(b);
		patients.add(a);
		patients.add(d);

		java.util.Collections.sort(patients);
		// show that order is ..b,c.. (i.e. isBC) or that order is ..c,b.. (i.e. isCB)
		// indeterministic so either is acceptable
		boolean isBC = (patients.get(1).equals(b) || patients.get(2).equals(c) ) ;
		boolean isCB = (patients.get(1).equals(c) || patients.get(2).equals(b) ) ;
		assertTrue(isBC || isCB);
	}

	@Test
	public void sortEmptyCollectionDoesNotReturnError() {
		Patients patients = new Patients();
		java.util.Collections.sort(patients);
	}

}
