package com.agilex.healthcare.mobilehealthplatform.domain;

import static org.junit.Assert.assertEquals;

import java.net.URI;

import org.junit.Test;

public class SecureMessageUserTest {

	private static final String SAVE_DRAFT = "save-draft";
	private static final String SEND = "send";
	private static final String CONTACTS = "contacts";
	private static final String FOLDERS = "folders";
	private static final String SM_USER_URI = "smUserUri";
	
	private SecureMessageUser smUser;

	public SecureMessageUserTest() throws Exception{
		smUser = new SecureMessageUser();
		smUser.setLastName("Younger");
		smUser.setFirstName("Gallow");
		
		URI selfUri = new URI(SM_USER_URI);
		smUser.setSelfUri(selfUri);
		
		smUser.getLink().addRelatedLink(FOLDERS, new URI(FOLDERS));
		smUser.getLink().addRelatedLink(CONTACTS, new URI(CONTACTS));
		smUser.getLink().addRelatedLink(SEND, new URI(SEND));
		smUser.getLink().addRelatedLink(SAVE_DRAFT, new URI(SAVE_DRAFT));

	}

	@Test
	public void validateSelfUri() {
		assertEquals(SM_USER_URI, smUser.getUri());
	}

	@Test
	public void validateFoldersUri() {
		assertEquals(FOLDERS, smUser.getFoldersUri());
	}

	@Test
	public void validateContactsUri() {
		assertEquals(CONTACTS, smUser.getContactsUri());
	}
	
	@Test
	public void validateSendUri() {
		assertEquals(SEND, smUser.getSendUri());
	}

	@Test
	public void validateSaveDraftUri() {
		assertEquals(SAVE_DRAFT, smUser.getSaveDraftUri());
	}
}
